/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import junit.framework.TestCase;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.protocol.java.control.gui.ClassFilter;
import org.apache.jmeter.protocol.java.sampler.JUnitSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JOrphanUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="junit_request")
public class JUnitTestSamplerGui
extends AbstractSamplerGui
implements ChangeListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log;
    private static final String TESTMETHOD_PREFIX = "test";
    private static final String ONETIMESETUP = "oneTimeSetUp";
    private static final String ONETIMETEARDOWN = "oneTimeTearDown";
    private static final String SUITE = "suite";
    private static final AtomicBoolean IS_INITILIAZED;
    private static final String[] SPATHS;
    private final JTextField constructorLabel = new JTextField();
    private final JTextField successMsg = new JTextField();
    private final JTextField failureMsg = new JTextField();
    private final JTextField errorMsg = new JTextField();
    private final JTextField successCode = new JTextField();
    private final JTextField failureCode = new JTextField();
    private final JTextField errorCode = new JTextField();
    private final JLabeledTextField filterpkg = new JLabeledTextField(JMeterUtils.getResString((String)"junit_pkg_filter"), 50);
    private final JCheckBox doSetup = new JCheckBox(JMeterUtils.getResString((String)"junit_do_setup_teardown"));
    private final JCheckBox appendError = new JCheckBox(JMeterUtils.getResString((String)"junit_append_error"));
    private final JCheckBox appendExc = new JCheckBox(JMeterUtils.getResString((String)"junit_append_exception"));
    private final JCheckBox junit4 = new JCheckBox(JMeterUtils.getResString((String)"junit_junit4"));
    private final JCheckBox createInstancePerSample = new JCheckBox(JMeterUtils.getResString((String)"junit_create_instance_per_sample"));
    private JComboBox<String> classnameCombo;
    private JComboBox<String> methodName;
    private final transient ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
    private static List<String> annotatedTestClasses;
    private static List<String> junitTestClasses;

    public JUnitTestSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "junit_request";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createClassPanel(), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupClasslist(boolean initialize) {
        this.classnameCombo.removeAllItems();
        this.methodName.removeAllItems();
        try {
            String[] clist;
            List<String> classList = new ArrayList<String>();
            if (initialize) {
                AtomicBoolean atomicBoolean = IS_INITILIAZED;
                synchronized (atomicBoolean) {
                    if (IS_INITILIAZED.compareAndSet(false, true)) {
                        List junitClasses;
                        List annotatedClasses;
                        annotatedTestClasses = annotatedClasses = ClassFinder.findAnnotatedClasses((String[])SPATHS, (Class[])new Class[]{Test.class}, (boolean)false);
                        junitTestClasses = junitClasses = ClassFinder.findClassesThatExtend((String[])SPATHS, (Class[])new Class[]{TestCase.class});
                    }
                    classList = this.junit4.isSelected() ? annotatedTestClasses : junitTestClasses;
                }
            }
            ClassFilter filter = new ClassFilter();
            filter.setPackges(JOrphanUtils.split((String)this.filterpkg.getText(), (String)","));
            for (String classStr : clist = filter.filterArray(classList)) {
                this.classnameCombo.addItem(classStr);
            }
        }
        catch (IOException e) {
            log.error("Exception getting interfaces.", (Throwable)e);
        }
    }

    private JPanel createClassPanel() {
        this.classnameCombo = new JComboBox();
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setEditable(false);
        this.methodName = new JComboBox();
        this.methodName.addActionListener(this);
        this.setupClasslist(false);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        panel.add((Component)this.junit4, "span 2");
        this.junit4.addItemListener(this);
        panel.add((Component)this.filterpkg, "span 2");
        this.filterpkg.addChangeListener((ChangeListener)this);
        panel.add(JMeterUtils.labelFor(this.classnameCombo, (String)"protocol_java_classname"));
        panel.add(this.classnameCombo);
        this.constructorLabel.setText("");
        panel.add(JMeterUtils.labelFor((Component)this.constructorLabel, (String)"junit_constructor_string"));
        panel.add(this.constructorLabel);
        panel.add(JMeterUtils.labelFor(this.methodName, (String)"junit_test_method"));
        panel.add(this.methodName);
        panel.add(JMeterUtils.labelFor((Component)this.successMsg, (String)"junit_success_msg"));
        panel.add(this.successMsg);
        panel.add(JMeterUtils.labelFor((Component)this.successCode, (String)"junit_success_code"));
        panel.add(this.successCode);
        panel.add(JMeterUtils.labelFor((Component)this.failureMsg, (String)"junit_failure_msg"));
        panel.add(this.failureMsg);
        panel.add(JMeterUtils.labelFor((Component)this.failureCode, (String)"junit_failure_code"));
        panel.add(this.failureCode);
        panel.add(JMeterUtils.labelFor((Component)this.errorMsg, (String)"junit_error_msg"));
        panel.add(this.errorMsg);
        panel.add(JMeterUtils.labelFor((Component)this.errorCode, (String)"junit_error_code"));
        panel.add(this.errorCode);
        panel.add((Component)this.doSetup, "span 2");
        panel.add((Component)this.appendError, "span 2");
        panel.add((Component)this.appendExc, "span 2");
        panel.add((Component)this.createInstancePerSample, "span 2");
        return panel;
    }

    private void initGui() {
        this.appendError.setSelected(false);
        this.appendExc.setSelected(false);
        this.createInstancePerSample.setSelected(false);
        this.doSetup.setSelected(false);
        this.junit4.setSelected(false);
        this.filterpkg.setText("");
        this.constructorLabel.setText("");
        this.successCode.setText(JMeterUtils.getResString((String)"junit_success_default_code"));
        this.successMsg.setText(JMeterUtils.getResString((String)"junit_success_default_msg"));
        this.failureCode.setText(JMeterUtils.getResString((String)"junit_failure_default_code"));
        this.failureMsg.setText(JMeterUtils.getResString((String)"junit_failure_default_msg"));
        this.errorMsg.setText(JMeterUtils.getResString((String)"junit_error_default_msg"));
        this.errorCode.setText(JMeterUtils.getResString((String)"junit_error_default_code"));
        this.setupClasslist(true);
    }

    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    public TestElement createTestElement() {
        JUnitSampler sampler = new JUnitSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement el) {
        JUnitSampler sampler = (JUnitSampler)el;
        this.configureTestElement((TestElement)sampler);
        if (this.classnameCombo.getSelectedItem() != null && this.classnameCombo.getSelectedItem() instanceof String) {
            sampler.setClassname((String)this.classnameCombo.getSelectedItem());
        } else {
            sampler.setClassname(null);
        }
        sampler.setConstructorString(this.constructorLabel.getText());
        if (this.methodName.getSelectedItem() != null) {
            Object mobj = this.methodName.getSelectedItem();
            sampler.setMethod((String)mobj);
        } else {
            sampler.setMethod(null);
        }
        sampler.setFilterString(this.filterpkg.getText());
        sampler.setSuccess(this.successMsg.getText());
        sampler.setSuccessCode(this.successCode.getText());
        sampler.setFailure(this.failureMsg.getText());
        sampler.setFailureCode(this.failureCode.getText());
        sampler.setError(this.errorMsg.getText());
        sampler.setErrorCode(this.errorCode.getText());
        sampler.setDoNotSetUpTearDown(this.doSetup.isSelected());
        sampler.setAppendError(this.appendError.isSelected());
        sampler.setAppendException(this.appendExc.isSelected());
        sampler.setCreateOneInstancePerSample(this.createInstancePerSample.isSelected());
        sampler.setJunit4(this.junit4.isSelected());
    }

    public void configure(TestElement el) {
        super.configure(el);
        JUnitSampler sampler = (JUnitSampler)el;
        this.junit4.setSelected(sampler.getJunit4());
        this.filterpkg.setText(sampler.getFilterString());
        this.classnameCombo.setSelectedItem(sampler.getClassname());
        this.setupMethods();
        this.methodName.setSelectedItem(sampler.getMethod());
        this.constructorLabel.setText(sampler.getConstructorString());
        if (sampler.getSuccessCode().length() > 0) {
            this.successCode.setText(sampler.getSuccessCode());
        } else {
            this.successCode.setText(JMeterUtils.getResString((String)"junit_success_default_code"));
        }
        if (sampler.getSuccess().length() > 0) {
            this.successMsg.setText(sampler.getSuccess());
        } else {
            this.successMsg.setText(JMeterUtils.getResString((String)"junit_success_default_msg"));
        }
        if (sampler.getFailureCode().length() > 0) {
            this.failureCode.setText(sampler.getFailureCode());
        } else {
            this.failureCode.setText(JMeterUtils.getResString((String)"junit_failure_default_code"));
        }
        if (sampler.getFailure().length() > 0) {
            this.failureMsg.setText(sampler.getFailure());
        } else {
            this.failureMsg.setText(JMeterUtils.getResString((String)"junit_failure_default_msg"));
        }
        if (sampler.getError().length() > 0) {
            this.errorMsg.setText(sampler.getError());
        } else {
            this.errorMsg.setText(JMeterUtils.getResString((String)"junit_error_default_msg"));
        }
        if (sampler.getErrorCode().length() > 0) {
            this.errorCode.setText(sampler.getErrorCode());
        } else {
            this.errorCode.setText(JMeterUtils.getResString((String)"junit_error_default_code"));
        }
        this.doSetup.setSelected(sampler.getDoNotSetUpTearDown());
        this.appendError.setSelected(sampler.getAppendError());
        this.appendExc.setSelected(sampler.getAppendException());
        this.createInstancePerSample.setSelected(sampler.getCreateOneInstancePerSample());
    }

    private void setupMethods() {
        String className = (String)this.classnameCombo.getSelectedItem();
        this.methodName.removeAllItems();
        if (className != null) {
            try {
                String[] names;
                Class<?> testClass = Class.forName(className, false, this.contextClassLoader);
                for (String name : names = this.getMethodNames(testClass)) {
                    this.methodName.addItem(name);
                }
                this.methodName.repaint();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private String[] getMethodNames(Class<?> clazz) {
        Method[] meths = clazz.getMethods();
        ArrayList<String> list = new ArrayList<String>();
        for (Method method : meths) {
            String name = method.getName();
            if (this.junit4.isSelected()) {
                if (!method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(BeforeClass.class) && !method.isAnnotationPresent(AfterClass.class)) continue;
                list.add(name);
                continue;
            }
            if (!name.startsWith(TESTMETHOD_PREFIX) && !name.equals(ONETIMESETUP) && !name.equals(ONETIMETEARDOWN) && !name.equals(SUITE)) continue;
            list.add(name);
        }
        if (!list.isEmpty()) {
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.classnameCombo) {
            this.setupMethods();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItem() == this.junit4) {
            this.setupClasslist(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.filterpkg) {
            this.setupClasslist(true);
        }
    }

    static {
        String[] paths;
        log = LoggerFactory.getLogger(JUnitTestSamplerGui.class);
        IS_INITILIAZED = new AtomicBoolean(Boolean.FALSE);
        String ucp = JMeterUtils.getProperty((String)"user.classpath");
        if (ucp != null) {
            String[] parts = ucp.split(File.pathSeparator);
            paths = new String[parts.length + 1];
            paths[0] = JMeterUtils.getJMeterHome() + "/lib/junit/";
            System.arraycopy(parts, 0, paths, 1, parts.length);
        } else {
            paths = new String[]{JMeterUtils.getJMeterHome() + "/lib/junit/"};
        }
        SPATHS = paths;
    }
}

