/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.transaction.txn.TxnId;

public class TxnIdSimple
implements TxnId {
    private static AtomicLong counter = new AtomicLong(0L);
    private final long x;

    static TxnIdSimple create() {
        return new TxnIdSimple(counter.incrementAndGet());
    }

    public static TxnIdSimple create(byte[] bytes) {
        return new TxnIdSimple(Bytes.getLong((byte[])bytes));
    }

    public TxnIdSimple(long x) {
        this.x = x;
    }

    @Override
    public String name() {
        return String.format("0x%04X", this.x);
    }

    @Override
    public byte[] bytes() {
        return Bytes.packLong((long)this.x);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.x);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TxnIdSimple other = (TxnIdSimple)obj;
        return this.x == other.x;
    }

    public String toString() {
        return "txn:" + this.x;
    }

    @Override
    public long runtime() {
        return this.x;
    }
}

