/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt.introspection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class TokenIntrospectionResponse {
    private final boolean active;
    private final Optional<String> scope;
    private final Optional<String> clientId;
    private final Optional<String> username;
    private final Optional<String> tokenType;
    private final Optional<Integer> exp;
    private final Optional<Integer> iat;
    private final Optional<Integer> nbf;
    private final Optional<String> sub;
    private final Optional<String> aud;
    private final Optional<String> iss;
    private final Optional<String> jti;
    private final JsonNode json;

    public static TokenIntrospectionResponse parse(JsonNode json) {
        return new TokenIntrospectionResponse(json);
    }

    public TokenIntrospectionResponse(JsonNode json) {
        Preconditions.checkNotNull((Object)json);
        JsonNode activeNode = json.get("active");
        Preconditions.checkArgument((boolean)(activeNode instanceof BooleanNode), (Object)"Missing / invalid boolean 'active' parameter");
        this.active = activeNode.asBoolean();
        this.scope = Optional.ofNullable(json.get("scope")).map(JsonNode::asText);
        this.clientId = Optional.ofNullable(json.get("client_id")).map(JsonNode::asText);
        this.username = Optional.ofNullable(json.get("username")).map(JsonNode::asText);
        this.tokenType = Optional.ofNullable(json.get("token_type")).map(JsonNode::asText);
        this.exp = Optional.ofNullable(json.get("exp")).map(JsonNode::asInt);
        this.iat = Optional.ofNullable(json.get("iat")).map(JsonNode::asInt);
        this.nbf = Optional.ofNullable(json.get("nbf")).map(JsonNode::asInt);
        this.sub = Optional.ofNullable(json.get("sub")).map(JsonNode::asText);
        this.aud = Optional.ofNullable(json.get("aud")).map(JsonNode::asText);
        this.iss = Optional.ofNullable(json.get("iss")).map(JsonNode::asText);
        this.jti = Optional.ofNullable(json.get("jti")).map(JsonNode::asText);
        this.json = json;
    }

    public boolean active() {
        return this.active;
    }

    public Optional<String> scope() {
        return this.scope;
    }

    public JsonNode json() {
        return this.json;
    }

    public Optional<String> clientId() {
        return this.clientId;
    }

    public Optional<String> username() {
        return this.username;
    }

    public Optional<String> tokenType() {
        return this.tokenType;
    }

    public Optional<Integer> exp() {
        return this.exp;
    }

    public Optional<Integer> iat() {
        return this.iat;
    }

    public Optional<Integer> nbf() {
        return this.nbf;
    }

    public Optional<String> sub() {
        return this.sub;
    }

    public Optional<String> aud() {
        return this.aud;
    }

    public Optional<String> iss() {
        return this.iss;
    }

    public Optional<String> jti() {
        return this.jti;
    }

    public Optional<String> claimByPropertyName(String propertyName) {
        return Optional.ofNullable(this.json.get(propertyName)).map(JsonNode::asText);
    }
}

