/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.jpa;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnit;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.jpa.model.JPADomain;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPADomainList
extends AbstractDomainList {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPADomainList.class);
    private EntityManagerFactory entityManagerFactory;

    @Inject
    public JPADomainList(DNSService dns, EntityManagerFactory entityManagerFactory) {
        super(dns);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Inject
    @PersistenceUnit(unitName="James")
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    public void init() {
        EntityManagerUtils.safelyClose((EntityManager)this.createEntityManager());
    }

    protected List<Domain> getDomainListInternal() throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            List resultList = entityManager.createNamedQuery("listDomainNames").getResultList();
            List list = (List)resultList.stream().map(Domain::of).collect(ImmutableList.toImmutableList());
            return list;
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to list domains", (Throwable)e);
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    protected boolean containsDomainInternal(Domain domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            boolean bl = this.containsDomainInternal(domain, entityManager);
            return bl;
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to find domain", (Throwable)e);
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void addDomain(Domain domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (this.containsDomainInternal(domain, entityManager)) {
                transaction.commit();
                throw new DomainListException(domain.name() + " already exists.");
            }
            JPADomain jpaDomain = new JPADomain(domain);
            entityManager.persist((Object)jpaDomain);
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to save domain", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to add domain " + domain.name(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    public void doRemoveDomain(Domain domain) throws DomainListException {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (!this.containsDomainInternal(domain, entityManager)) {
                transaction.commit();
                throw new DomainListException(domain.name() + " was not found.");
            }
            entityManager.createNamedQuery("deleteDomainByName").setParameter("name", (Object)domain.asString()).executeUpdate();
            transaction.commit();
        }
        catch (PersistenceException e) {
            LOGGER.error("Failed to remove domain", (Throwable)e);
            this.rollback(transaction);
            throw new DomainListException("Unable to remove domain " + domain.name(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)entityManager);
        }
    }

    private void rollback(EntityTransaction transaction) {
        if (transaction.isActive()) {
            transaction.rollback();
        }
    }

    private boolean containsDomainInternal(Domain domain, EntityManager entityManager) {
        try {
            return entityManager.createNamedQuery("findDomainByName").setParameter("name", (Object)domain.asString()).getSingleResult() != null;
        }
        catch (NoResultException e) {
            LOGGER.debug("No domain found", (Throwable)e);
            return false;
        }
    }

    private EntityManager createEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

