/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.james.jmap.api.access.AccessToken;
import org.apache.james.jmap.api.access.exceptions.InvalidAccessToken;
import org.apache.james.jmap.api.access.exceptions.NotAnAccessTokenException;
import org.apache.james.jmap.draft.api.AccessTokenManager;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class AccessTokenAuthenticationStrategy
implements AuthenticationStrategy {
    private final AccessTokenManager accessTokenManager;
    private final MailboxManager mailboxManager;

    @Inject
    @VisibleForTesting
    AccessTokenAuthenticationStrategy(AccessTokenManager accessTokenManager, MailboxManager mailboxManager) {
        this.accessTokenManager = accessTokenManager;
        this.mailboxManager = mailboxManager;
    }

    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return Mono.fromCallable(() -> this.authHeaders(httpRequest)).filter(tokenString -> !tokenString.startsWith("Bearer")).map(AccessToken::fromString).flatMap(item -> Mono.from(this.accessTokenManager.getUsernameFromToken((AccessToken)item))).map(arg_0 -> ((MailboxManager)this.mailboxManager).createSystemSession(arg_0)).onErrorResume(InvalidAccessToken.class, error -> Mono.error((Throwable)new UnauthorizedException("Invalid access token", (Throwable)error))).onErrorResume(NotAnAccessTokenException.class, error -> Mono.error((Throwable)new UnauthorizedException("Not an access token", (Throwable)error)));
    }

    public AuthenticationChallenge correspondingChallenge() {
        return AuthenticationChallenge.of((AuthenticationScheme)AuthenticationScheme.of((String)"Bearer"), (Map)ImmutableMap.of((Object)"realm", (Object)"JMAP Draft access token"));
    }
}

