/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableList;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.components.CassandraType;

public class CassandraTypesCreator {
    private final ImmutableList<CassandraType> types;
    private final Session session;

    public CassandraTypesCreator(CassandraModule module, Session session) {
        this.types = ImmutableList.copyOf(module.moduleTypes());
        this.session = session;
    }

    public CassandraType.InitializationStatus initializeTypes() {
        KeyspaceMetadata keyspaceMetadata = this.session.getCluster().getMetadata().getKeyspace(this.session.getLoggedKeyspace());
        return this.types.stream().map(type -> type.initialize(keyspaceMetadata, this.session)).reduce((left, right) -> left.reduce((CassandraType.InitializationStatus)((Object)right))).orElse(CassandraType.InitializationStatus.ALREADY_DONE);
    }
}

