/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;

public class AggregateFilter
extends MonitoringFilter
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=728");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=730");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=729");
    private final DateTime startTime;
    private final NodeId aggregateType;
    private final Double processingInterval;
    private final AggregateConfiguration aggregateConfiguration;

    public AggregateFilter(DateTime startTime, NodeId aggregateType, Double processingInterval, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.aggregateType = aggregateType;
        this.processingInterval = processingInterval;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public NodeId getAggregateType() {
        return this.aggregateType;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    protected AggregateFilter(AggregateFilterBuilder<?, ?> b) {
        super((MonitoringFilter.MonitoringFilterBuilder<?, ?>)b);
        this.startTime = ((AggregateFilterBuilder)b).startTime;
        this.aggregateType = ((AggregateFilterBuilder)b).aggregateType;
        this.processingInterval = ((AggregateFilterBuilder)b).processingInterval;
        this.aggregateConfiguration = ((AggregateFilterBuilder)b).aggregateConfiguration;
    }

    public static AggregateFilterBuilder<?, ?> builder() {
        return new AggregateFilterBuilderImpl();
    }

    public AggregateFilterBuilder<?, ?> toBuilder() {
        return new AggregateFilterBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateFilter)) {
            return false;
        }
        AggregateFilter other = (AggregateFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$processingInterval = this.getProcessingInterval();
        Double other$processingInterval = other.getProcessingInterval();
        if (this$processingInterval == null ? other$processingInterval != null : !((Object)this$processingInterval).equals(other$processingInterval)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        NodeId this$aggregateType = this.getAggregateType();
        NodeId other$aggregateType = other.getAggregateType();
        if (this$aggregateType == null ? other$aggregateType != null : !((Object)this$aggregateType).equals(other$aggregateType)) {
            return false;
        }
        AggregateConfiguration this$aggregateConfiguration = this.getAggregateConfiguration();
        AggregateConfiguration other$aggregateConfiguration = other.getAggregateConfiguration();
        return !(this$aggregateConfiguration == null ? other$aggregateConfiguration != null : !((Object)this$aggregateConfiguration).equals(other$aggregateConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AggregateFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $processingInterval = this.getProcessingInterval();
        result = result * 59 + ($processingInterval == null ? 43 : ((Object)$processingInterval).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        NodeId $aggregateType = this.getAggregateType();
        result = result * 59 + ($aggregateType == null ? 43 : ((Object)$aggregateType).hashCode());
        AggregateConfiguration $aggregateConfiguration = this.getAggregateConfiguration();
        result = result * 59 + ($aggregateConfiguration == null ? 43 : ((Object)$aggregateConfiguration).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AggregateFilter(startTime=" + this.getStartTime() + ", aggregateType=" + this.getAggregateType() + ", processingInterval=" + this.getProcessingInterval() + ", aggregateConfiguration=" + this.getAggregateConfiguration() + ")";
    }

    private static final class AggregateFilterBuilderImpl
    extends AggregateFilterBuilder<AggregateFilter, AggregateFilterBuilderImpl> {
        private AggregateFilterBuilderImpl() {
        }

        @Override
        protected AggregateFilterBuilderImpl self() {
            return this;
        }

        @Override
        public AggregateFilter build() {
            return new AggregateFilter(this);
        }
    }

    public static abstract class AggregateFilterBuilder<C extends AggregateFilter, B extends AggregateFilterBuilder<C, B>>
    extends MonitoringFilter.MonitoringFilterBuilder<C, B> {
        private DateTime startTime;
        private NodeId aggregateType;
        private Double processingInterval;
        private AggregateConfiguration aggregateConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AggregateFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AggregateFilter instance, AggregateFilterBuilder<?, ?> b) {
            b.startTime(instance.startTime);
            b.aggregateType(instance.aggregateType);
            b.processingInterval(instance.processingInterval);
            b.aggregateConfiguration(instance.aggregateConfiguration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B aggregateType(NodeId aggregateType) {
            this.aggregateType = aggregateType;
            return (B)this.self();
        }

        public B processingInterval(Double processingInterval) {
            this.processingInterval = processingInterval;
            return (B)this.self();
        }

        public B aggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AggregateFilter.AggregateFilterBuilder(super=" + super.toString() + ", startTime=" + this.startTime + ", aggregateType=" + this.aggregateType + ", processingInterval=" + this.processingInterval + ", aggregateConfiguration=" + this.aggregateConfiguration + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AggregateFilter> {
        @Override
        public Class<AggregateFilter> getType() {
            return AggregateFilter.class;
        }

        @Override
        public AggregateFilter decode(SerializationContext context, UaDecoder decoder) {
            DateTime startTime = decoder.readDateTime("StartTime");
            NodeId aggregateType = decoder.readNodeId("AggregateType");
            Double processingInterval = decoder.readDouble("ProcessingInterval");
            AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)decoder.readStruct("AggregateConfiguration", AggregateConfiguration.TYPE_ID);
            return new AggregateFilter(startTime, aggregateType, processingInterval, aggregateConfiguration);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AggregateFilter value) {
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeNodeId("AggregateType", value.getAggregateType());
            encoder.writeDouble("ProcessingInterval", value.getProcessingInterval());
            encoder.writeStruct("AggregateConfiguration", (Object)value.getAggregateConfiguration(), AggregateConfiguration.TYPE_ID);
        }
    }
}

