/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.InlongGroupContext;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;

@Parameters(commandDescription="Restart resource by group id")
public class RestartCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public RestartCommand() {
        super("restart");
        this.jcommander.addCommand("group", (Object)new RestartGroup());
    }

    @Parameters(commandDescription="Restart the inlong group task")
    private static class RestartGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--group", "-g"}, required=true, description="inlong group id")
        private String inlongGroupId;

        private RestartGroup() {
        }

        @Override
        void run() {
            try {
                InlongClientImpl inlongClient = ClientUtils.getClient();
                InlongGroup group = inlongClient.getGroup(this.inlongGroupId);
                InlongGroupContext context = group.restart();
                if (!SimpleGroupStatus.STARTED.equals((Object)context.getStatus())) {
                    throw new Exception("Restart group failed, current status: " + context.getStatus());
                }
                System.out.println("Restart group success!");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

