/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.net;

import com.moilioncircle.redis.replicator.net.SslContextFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class RedisSslContextFactory
implements SslContextFactory {
    private String protocol = "TLS";
    private String keyStorePath;
    private String keyStoreType;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStoreType;
    private String trustStorePassword;
    private final ClassLoader loader;

    public RedisSslContextFactory() {
        this(null);
    }

    public RedisSslContextFactory(ClassLoader loader) {
        this.loader = loader;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public RedisSslContextFactory setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public RedisSslContextFactory setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public RedisSslContextFactory setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public RedisSslContextFactory setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public RedisSslContextFactory setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public RedisSslContextFactory setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public RedisSslContextFactory setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    @Override
    public SSLContext create() {
        try {
            InputStream in;
            KeyStore ks;
            SSLContext context = SSLContext.getInstance(Objects.requireNonNull(this.protocol));
            KeyManager[] kms = null;
            TrustManager[] tms = new TrustManager[]{new TrustAllManager()};
            if (this.keyStorePath != null) {
                ks = KeyStore.getInstance(Objects.requireNonNull(this.keyStoreType));
                in = this.getInputStream(this.loader, this.keyStorePath);
                try {
                    ks.load(in, Objects.requireNonNull(this.keyStorePassword).toCharArray());
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, Objects.requireNonNull(this.keyStorePassword).toCharArray());
                    kms = kmf.getKeyManagers();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (this.trustStorePath != null) {
                ks = KeyStore.getInstance(Objects.requireNonNull(this.trustStoreType));
                in = this.getInputStream(this.loader, this.keyStorePath);
                try {
                    ks.load(in, Objects.requireNonNull(this.trustStorePassword).toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    tms = tmf.getTrustManagers();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            context.init(kms, tms, null);
            return context;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected InputStream getInputStream(ClassLoader loader, String path) throws Exception {
        if (loader == null) {
            return new FileInputStream(path);
        }
        return loader.getResourceAsStream(path);
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

