/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.tools.cli;

import com.google.gson.JsonObject;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.CliArgDef;
import org.apache.inlong.tubemq.server.common.utils.HttpUtils;
import org.apache.inlong.tubemq.server.tools.cli.CliAbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliBrokerAdmin
extends CliAbstractBase {
    private static final Logger logger = LoggerFactory.getLogger(CliBrokerAdmin.class);
    private static final String defBrokerPortal = "127.0.0.1:8081";

    public CliBrokerAdmin() {
        super("tubemq-broker-admin.sh");
        this.initCommandOptions();
    }

    @Override
    protected void initCommandOptions() {
        this.addCommandOption(CliArgDef.BROKERPORTAL);
        this.addCommandOption(CliArgDef.ADMINMETHOD);
        this.addCommandOption(CliArgDef.METHOD);
    }

    @Override
    public boolean processParams(String[] args) throws Exception {
        String methodStr;
        CommandLine cli = this.parser.parse(this.options, args);
        if (cli == null) {
            throw new ParseException("Parse args failure");
        }
        if (cli.hasOption(CliArgDef.VERSION.longOpt)) {
            this.version();
        }
        if (cli.hasOption(CliArgDef.HELP.longOpt)) {
            this.help();
        }
        String brokerAddr = defBrokerPortal;
        if (cli.hasOption(CliArgDef.BROKERPORTAL.longOpt) && TStringUtils.isBlank((String)(brokerAddr = cli.getOptionValue(CliArgDef.BROKERPORTAL.longOpt)))) {
            throw new Exception(CliArgDef.BROKERPORTAL.longOpt + " is required!");
        }
        JsonObject result = null;
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        String brokerUrl = "http://" + brokerAddr + "/broker.htm";
        if (cli.hasOption(CliArgDef.ADMINMETHOD.longOpt)) {
            inParamMap.put(CliArgDef.METHOD.longOpt, "admin_get_methods");
            result = HttpUtils.requestWebService(brokerUrl, inParamMap);
            System.out.println(result.toString());
            System.exit(0);
        }
        if (TStringUtils.isBlank((String)(methodStr = cli.getOptionValue(CliArgDef.METHOD.longOpt)))) {
            throw new Exception(CliArgDef.METHOD.longOpt + " is required!");
        }
        inParamMap.put(CliArgDef.METHOD.longOpt, methodStr);
        result = HttpUtils.requestWebService(brokerUrl, inParamMap);
        System.out.println(result.toString());
        return true;
    }

    public static void main(String[] args) {
        CliBrokerAdmin cliBrokerAdmin = new CliBrokerAdmin();
        try {
            cliBrokerAdmin.processParams(args);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            cliBrokerAdmin.help();
        }
    }
}

