/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.KeyBuilderUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbGroupFilterCondEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;

public class GroupConsumeCtrlEntity
extends BaseEntity
implements Cloneable {
    private String recordKey = "";
    private String topicName = "";
    private String groupName = "";
    private EnableStatus consumeEnable = EnableStatus.STATUS_UNDEFINE;
    private String disableReason = "";
    private EnableStatus filterEnable = EnableStatus.STATUS_UNDEFINE;
    private String filterCondStr = "";

    public GroupConsumeCtrlEntity() {
    }

    public GroupConsumeCtrlEntity(BaseEntity opInfoEntity, String groupName, String topicName) {
        super(opInfoEntity);
        this.setGroupAndTopic(groupName, topicName);
    }

    public GroupConsumeCtrlEntity(BdbGroupFilterCondEntity bdbEntity) {
        super(bdbEntity.getDataVerId(), bdbEntity.getModifyUser(), bdbEntity.getModifyDate());
        this.setCreateInfo(bdbEntity.getCreateUser(), bdbEntity.getCreateDate());
        this.setGroupAndTopic(bdbEntity.getConsumerGroupName(), bdbEntity.getTopicName());
        this.filterEnable = bdbEntity.getControlStatus() == 2 ? EnableStatus.STATUS_ENABLE : (bdbEntity.getControlStatus() == -2 ? EnableStatus.STATUS_UNDEFINE : EnableStatus.STATUS_DISABLE);
        this.consumeEnable = bdbEntity.getConsumeEnable();
        this.disableReason = bdbEntity.getDisableConsumeReason();
        this.filterCondStr = bdbEntity.getFilterCondStr();
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbGroupFilterCondEntity buildBdbGroupFilterCondEntity() {
        BdbGroupFilterCondEntity bdbEntity = new BdbGroupFilterCondEntity(this.topicName, this.groupName, this.filterEnable.getCode(), this.filterCondStr, this.getAttributes(), this.getModifyUser(), this.getModifyDate());
        bdbEntity.setCreateInfo(this.getCreateUser(), this.getCreateDate());
        bdbEntity.setDataVerId(this.getDataVerId());
        bdbEntity.setConsumeEnable(this.consumeEnable);
        bdbEntity.setDisableConsumeReason(this.disableReason);
        return bdbEntity;
    }

    public void setGroupAndTopic(String groupName, String topicName) {
        this.groupName = groupName;
        this.topicName = topicName;
        this.recordKey = KeyBuilderUtils.buildGroupTopicRecKey((String)groupName, (String)topicName);
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public EnableStatus getConsumeEnable() {
        return this.consumeEnable;
    }

    public boolean isEnableConsume() {
        return this.consumeEnable.isEnable();
    }

    public void setConsumeEnable(EnableStatus consumeEnable) {
        if (consumeEnable != null) {
            this.consumeEnable = consumeEnable;
        }
    }

    public String getDisableReason() {
        return this.disableReason;
    }

    public void setDisableReason(String disableReason) {
        this.disableReason = disableReason;
    }

    public boolean isEnableFilterConsume() {
        return this.filterEnable == EnableStatus.STATUS_ENABLE;
    }

    public void setFilterEnable(EnableStatus filterEnable) {
        if (filterEnable != null) {
            this.filterEnable = filterEnable;
        }
    }

    public String getFilterCondStr() {
        return this.filterCondStr;
    }

    public void setFilterCondStr(String filterCondStr) {
        this.filterCondStr = filterCondStr;
    }

    public EnableStatus getFilterEnable() {
        return this.filterEnable;
    }

    public boolean updModifyInfo(long dataVerId, EnableStatus consumeEnable, String disableRsn, EnableStatus filterEnable, String filterCondStr) {
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (consumeEnable != null && consumeEnable != EnableStatus.STATUS_UNDEFINE && this.consumeEnable != consumeEnable) {
            changed = true;
            this.setConsumeEnable(consumeEnable);
        }
        if (disableRsn != null && !disableRsn.equals(this.disableReason)) {
            changed = true;
            this.disableReason = disableRsn;
        }
        if (filterEnable != null && filterEnable != EnableStatus.STATUS_UNDEFINE && this.filterEnable != filterEnable) {
            changed = true;
            this.setFilterEnable(filterEnable);
        }
        if (TStringUtils.isNotBlank((String)filterCondStr) && !filterCondStr.equals(this.filterCondStr)) {
            changed = true;
            this.filterCondStr = filterCondStr;
        }
        if (changed) {
            this.updSerialId();
        }
        return changed;
    }

    public GroupConsumeCtrlEntity fillEmptyValues() {
        if (this.filterEnable == EnableStatus.STATUS_UNDEFINE) {
            this.filterEnable = EnableStatus.STATUS_DISABLE;
        }
        if (this.consumeEnable == EnableStatus.STATUS_UNDEFINE) {
            this.consumeEnable = EnableStatus.STATUS_ENABLE;
        }
        return this;
    }

    public boolean isMatched(GroupConsumeCtrlEntity target) {
        if (target == null) {
            return true;
        }
        if (!super.isMatched(target)) {
            return false;
        }
        return !(!TStringUtils.isBlank((String)target.getTopicName()) && !target.getTopicName().equals(this.topicName) || !TStringUtils.isBlank((String)target.getGroupName()) && !target.getGroupName().equals(this.groupName) || target.getConsumeEnable() != EnableStatus.STATUS_UNDEFINE && target.getConsumeEnable() != this.consumeEnable || target.getFilterEnable() != EnableStatus.STATUS_UNDEFINE && target.getFilterEnable() != this.filterEnable);
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName, boolean fullFormat) {
        String tmpFilterConds = this.filterCondStr;
        if (tmpFilterConds.length() <= 2) {
            tmpFilterConds = "";
        }
        if (isLongName) {
            sBuilder.append("{\"topicName\":\"").append(this.topicName).append("\"").append(",\"groupName\":\"").append(this.groupName).append("\"").append(",\"consumeEnable\":").append(this.consumeEnable.isEnable()).append(",\"disableCsmRsn\":\"").append(this.disableReason).append("\"").append(",\"filterEnable\":").append(this.filterEnable.isEnable()).append(",\"filterConds\":\"").append(tmpFilterConds).append("\"");
        } else {
            sBuilder.append("{\"topic\":\"").append(this.topicName).append("\"").append(",\"group\":\"").append(this.groupName).append("\"").append(",\"csmEn\":").append(this.consumeEnable.isEnable()).append(",\"dsCsmRsn\":\"").append(this.disableReason).append("\"").append(",\"fltEn\":").append(this.filterEnable.isEnable()).append(",\"fltRls\":\"").append(tmpFilterConds).append("\"");
        }
        super.toWebJsonStr(sBuilder, isLongName);
        if (fullFormat) {
            sBuilder.append("}");
        }
        return sBuilder;
    }

    public boolean isDataEquals(GroupConsumeCtrlEntity other) {
        return super.isDataEquals(other) && this.recordKey.equals(other.recordKey) && Objects.equals(this.topicName, other.topicName) && Objects.equals(this.groupName, other.groupName) && this.consumeEnable == other.consumeEnable && Objects.equals(this.disableReason, other.disableReason) && this.filterEnable == other.filterEnable && Objects.equals(this.filterCondStr, other.filterCondStr);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupConsumeCtrlEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupConsumeCtrlEntity that = (GroupConsumeCtrlEntity)o;
        return this.isDataEquals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.recordKey, this.topicName, this.groupName, this.consumeEnable, this.disableReason, this.filterEnable, this.filterCondStr});
    }

    @Override
    public GroupConsumeCtrlEntity clone() {
        GroupConsumeCtrlEntity copy = (GroupConsumeCtrlEntity)super.clone();
        copy.setConsumeEnable(this.getConsumeEnable());
        copy.setFilterEnable(this.getFilterEnable());
        return copy;
    }
}

