/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.msgstore.disk;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.broker.BrokerConfig;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.FileSegment;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.FileSegmentList;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.GetMessageResult;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.Segment;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.SegmentList;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.SegmentType;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.MsgStoreStatsHolder;
import org.apache.inlong.tubemq.server.broker.stats.TrafficInfo;
import org.apache.inlong.tubemq.server.broker.utils.DataStoreUtils;
import org.apache.inlong.tubemq.server.broker.utils.DiskSamplePrint;
import org.apache.inlong.tubemq.server.common.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgFileStore
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MsgFileStore.class);
    private static final int MAX_META_REFRESH_DUR = 3600000;
    private static final DiskSamplePrint samplePrintCtrl = new DiskSamplePrint(logger);
    private final String storeKey;
    private final File dataDir;
    private final File indexDir;
    private final AtomicInteger curUnflushed = new AtomicInteger(0);
    private final AtomicLong curUnflushSize = new AtomicLong(0L);
    private final AtomicLong lastFlushTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong lastMetaFlushTime = new AtomicLong(0L);
    private final BrokerConfig tubeConfig;
    private final MsgStoreStatsHolder msgStoreStatsHolder;
    private final ReentrantLock writeLock = new ReentrantLock();
    private final ByteBuffer byteBufferIndex = ByteBuffer.allocate(28);
    private final MessageStore messageStore;
    private SegmentList dataSegments;
    private SegmentList indexSegments;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MsgFileStore(MessageStore messageStore, BrokerConfig tubeConfig, String baseStorePath, long offsetIfCreate) throws IOException {
        StringBuilder sBuilder = new StringBuilder(512);
        this.tubeConfig = tubeConfig;
        this.messageStore = messageStore;
        this.msgStoreStatsHolder = messageStore.getMsgStoreStatsHolder();
        this.storeKey = messageStore.getStoreKey();
        this.dataDir = new File(sBuilder.append(baseStorePath).append(File.separator).append(this.storeKey).toString());
        sBuilder.delete(0, sBuilder.length());
        this.indexDir = new File(sBuilder.append(baseStorePath).append(File.separator).append(this.storeKey).append(File.separator).append("index").toString());
        sBuilder.delete(0, sBuilder.length());
        FileUtil.checkDir(this.dataDir);
        FileUtil.checkDir(this.indexDir);
        this.loadSegments(SegmentType.DATA, offsetIfCreate, sBuilder);
        this.loadSegments(SegmentType.INDEX, offsetIfCreate, sBuilder);
        this.lastFlushTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple3<Boolean, Long, Long> appendMsg(boolean fromMem, long currTime, StringBuilder sb, int msgCnt, int indexSize, ByteBuffer indexBuffer, int dataSize, ByteBuffer dataBuffer, long leftTime, long rightTime) {
        boolean fileStoreOK;
        long indexOffset;
        long dataOffset;
        block21: {
            String newIndexFilePath;
            boolean isIndexSegFlushed;
            block22: {
                if (this.closed.get()) {
                    throw new IllegalStateException(new StringBuilder(512).append("Closed MessageStore for storeKey ").append(this.storeKey).toString());
                }
                boolean isDataSegFlushed = false;
                isIndexSegFlushed = false;
                boolean pendingMsgCntExceed = false;
                boolean pendingMsgSizeExceed = false;
                boolean pendingMsgTimeExceed = false;
                boolean isForceMetadata = false;
                long flushedMsgCnt = 0L;
                long flushedDataSize = 0L;
                dataOffset = -1L;
                indexOffset = -1L;
                String newDataFilePath = null;
                newIndexFilePath = null;
                fileStoreOK = false;
                this.writeLock.lock();
                try {
                    long inDataOffset;
                    long inIndexOffset;
                    Segment curDataSeg = this.dataSegments.last();
                    Segment curIndexSeg = this.indexSegments.last();
                    if (fromMem) {
                        inIndexOffset = dataBuffer.getLong(16);
                        inDataOffset = indexBuffer.getLong(4);
                    } else {
                        inIndexOffset = curIndexSeg.getLast();
                        inDataOffset = curDataSeg.getLast();
                        indexBuffer.putLong(4, inDataOffset);
                        dataBuffer.putLong(16, inIndexOffset);
                    }
                    this.curUnflushSize.addAndGet(dataSize);
                    dataOffset = curDataSeg.append(dataBuffer, leftTime, rightTime);
                    if (curDataSeg.getCachedSize() >= (long)this.tubeConfig.getMaxSegmentSize()) {
                        isDataSegFlushed = true;
                        long newDataOffset = curDataSeg.flush(true);
                        File newDataFile = new File(this.dataDir, DataStoreUtils.nameFromOffset(newDataOffset, ".tube"));
                        curDataSeg.setMutable(false);
                        newDataFilePath = newDataFile.getAbsolutePath();
                        this.dataSegments.append(new FileSegment(newDataOffset, newDataFile, SegmentType.DATA));
                    }
                    indexOffset = curIndexSeg.append(indexBuffer, leftTime, rightTime);
                    if (curIndexSeg.getCachedSize() >= (long)this.tubeConfig.getMaxIndexSegmentSize()) {
                        isIndexSegFlushed = true;
                        long newIndexOffset = curIndexSeg.flush(true);
                        curIndexSeg.setMutable(false);
                        File newIndexFile = new File(this.indexDir, DataStoreUtils.nameFromOffset(newIndexOffset, ".index"));
                        newIndexFilePath = newIndexFile.getAbsolutePath();
                        this.indexSegments.append(new FileSegment(newIndexOffset, newIndexFile, SegmentType.INDEX));
                    }
                    pendingMsgSizeExceed = this.messageStore.getUnflushDataHold() > 0 && this.curUnflushSize.get() >= (long)this.messageStore.getUnflushDataHold();
                    pendingMsgCntExceed = this.curUnflushed.addAndGet(msgCnt) >= this.messageStore.getUnflushThreshold();
                    boolean bl = pendingMsgTimeExceed = currTime - this.lastFlushTime.get() >= (long)this.messageStore.getUnflushInterval();
                    if (pendingMsgCntExceed || pendingMsgTimeExceed || pendingMsgSizeExceed || isDataSegFlushed || isIndexSegFlushed) {
                        boolean bl2 = isForceMetadata = isDataSegFlushed || isIndexSegFlushed || currTime - this.lastMetaFlushTime.get() > 3600000L;
                        if (!isDataSegFlushed) {
                            curDataSeg.flush(isForceMetadata);
                        }
                        if (!isIndexSegFlushed) {
                            curIndexSeg.flush(isForceMetadata);
                        }
                        flushedMsgCnt = this.curUnflushed.getAndSet(0);
                        flushedDataSize = this.curUnflushSize.getAndSet(0L);
                        this.lastFlushTime.set(currTime);
                        if (isForceMetadata) {
                            this.lastMetaFlushTime.set(this.lastFlushTime.get());
                        }
                    }
                    if (inIndexOffset != indexOffset || inDataOffset != dataOffset) {
                        ServiceStatusHolder.addWriteIOErrCnt();
                        BrokerSrvStatsHolder.incDiskIOExcCnt();
                        logger.error(sb.append("[File Store]: appendMsg data Error, storekey=").append(this.storeKey).append(",msgCnt=").append(msgCnt).append(",indexSize=").append(indexSize).append(",inIndexOffset=").append(inIndexOffset).append(",indexOffset=").append(indexOffset).append(",dataSize=").append(dataSize).append(",inDataOffset=").append(inDataOffset).append(",dataOffset=").append(dataOffset).toString());
                        sb.delete(0, sb.length());
                    } else {
                        fileStoreOK = true;
                    }
                    this.writeLock.unlock();
                    if (!fileStoreOK) break block21;
                    this.msgStoreStatsHolder.addFileFlushStatsInfo(msgCnt, indexSize, dataSize, flushedMsgCnt, flushedDataSize, isDataSegFlushed, isIndexSegFlushed, pendingMsgSizeExceed, pendingMsgCntExceed, pendingMsgTimeExceed, isForceMetadata, System.currentTimeMillis() - currTime);
                    if (!isDataSegFlushed) break block22;
                }
                catch (Throwable e) {
                    try {
                        if (!this.closed.get()) {
                            ServiceStatusHolder.addWriteIOErrCnt();
                            BrokerSrvStatsHolder.incDiskIOExcCnt();
                        }
                        samplePrintCtrl.printExceptionCaught(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.writeLock.unlock();
                        if (fileStoreOK) {
                            this.msgStoreStatsHolder.addFileFlushStatsInfo(msgCnt, indexSize, dataSize, flushedMsgCnt, flushedDataSize, isDataSegFlushed, isIndexSegFlushed, pendingMsgSizeExceed, pendingMsgCntExceed, pendingMsgTimeExceed, isForceMetadata, System.currentTimeMillis() - currTime);
                            if (isDataSegFlushed) {
                                logger.info(sb.append("[File Store] Created data segment ").append(newDataFilePath).toString());
                                sb.delete(0, sb.length());
                            }
                            if (isIndexSegFlushed) {
                                logger.info(sb.append("[File Store] Created index segment ").append(newIndexFilePath).toString());
                                sb.delete(0, sb.length());
                            }
                        }
                    }
                }
                logger.info(sb.append("[File Store] Created data segment ").append(newDataFilePath).toString());
                sb.delete(0, sb.length());
            }
            if (isIndexSegFlushed) {
                logger.info(sb.append("[File Store] Created index segment ").append(newIndexFilePath).toString());
                sb.delete(0, sb.length());
            }
        }
        return new Tuple3((Object)fileStoreOK, (Object)indexOffset, (Object)dataOffset);
    }

    public GetMessageResult getMessages(int partitionId, long lastRdOffset, long reqOffset, ByteBuffer indexBuffer, boolean isFilterConsume, Set<Integer> filterKeySet, String statsKeyBase, int maxMsgTransferSize, long reqRcvTime) {
        int retCode = 0;
        int totalSize = 0;
        String errInfo = "Ok";
        boolean result = true;
        int dataRealLimit = 0;
        int curIndexOffset = 0;
        int readedOffset = 0;
        Segment recordSeg = null;
        int curIndexPartitionId = 0;
        long curIndexDataOffset = 0L;
        int curIndexDataSize = 0;
        int curIndexKeyCode = 0;
        long recvTimeInMillsec = 0L;
        long maxDataLimitOffset = 0L;
        long lastRdDataOffset = 0L;
        StringBuilder sBuilder = new StringBuilder(512);
        long curDataMaxOffset = this.getDataMaxOffset();
        long curDataMinOffset = this.getDataMinOffset();
        HashMap<String, TrafficInfo> countMap = new HashMap<String, TrafficInfo>();
        ByteBuffer dataBuffer = ByteBuffer.allocate(327680);
        ArrayList<ClientBroker.TransferedMessage> transferedMessageList = new ArrayList<ClientBroker.TransferedMessage>();
        for (curIndexOffset = 0; curIndexOffset < indexBuffer.remaining(); curIndexOffset += 28) {
            curIndexPartitionId = indexBuffer.getInt();
            curIndexDataOffset = indexBuffer.getLong();
            curIndexDataSize = indexBuffer.getInt();
            curIndexKeyCode = indexBuffer.getInt();
            recvTimeInMillsec = indexBuffer.getLong();
            maxDataLimitOffset = curIndexDataOffset + (long)curIndexDataSize;
            if (curIndexDataOffset < 0L || curIndexDataSize <= 0 || curIndexDataSize > 29360180 || curIndexDataOffset < curDataMinOffset) {
                readedOffset = curIndexOffset + 28;
                continue;
            }
            if (curIndexDataOffset >= curDataMaxOffset || maxDataLimitOffset > curDataMaxOffset) {
                lastRdDataOffset = curIndexDataOffset;
                break;
            }
            if (curIndexPartitionId != partitionId || isFilterConsume && !filterKeySet.contains(curIndexKeyCode)) {
                lastRdDataOffset = maxDataLimitOffset;
                readedOffset = curIndexOffset + 28;
                continue;
            }
            if (reqRcvTime != 0L && recvTimeInMillsec < reqRcvTime) continue;
            try {
                if (recordSeg == null || curIndexDataOffset < recordSeg.getStart() || maxDataLimitOffset > recordSeg.getStart() + recordSeg.getCommitSize()) {
                    if (recordSeg != null) {
                        recordSeg.relViewRef();
                        recordSeg = null;
                    }
                    if ((recordSeg = this.dataSegments.getRecordSeg(curIndexDataOffset)) == null) continue;
                    if (this.closed.get()) {
                        throw new Exception("Read Service has closed!");
                    }
                }
                if (dataBuffer.capacity() < curIndexDataSize) {
                    dataBuffer = ByteBuffer.allocate(curIndexDataSize);
                }
                dataBuffer.clear();
                dataBuffer.limit(curIndexDataSize);
                recordSeg.read(dataBuffer, curIndexDataOffset);
                dataBuffer.flip();
                dataRealLimit = dataBuffer.limit();
                if (dataRealLimit < curIndexDataSize) {
                    lastRdDataOffset = curIndexDataOffset;
                    readedOffset = curIndexOffset + 28;
                    continue;
                }
            }
            catch (Throwable e2) {
                if (e2 instanceof IOException) {
                    ServiceStatusHolder.addReadIOErrCnt();
                    BrokerSrvStatsHolder.incDiskIOExcCnt();
                }
                samplePrintCtrl.printExceptionCaught(e2, this.messageStore.getStoreKey(), String.valueOf(partitionId));
                retCode = 500;
                sBuilder.delete(0, sBuilder.length());
                errInfo = sBuilder.append("Get message from file failure : ").append(e2.getCause()).toString();
                sBuilder.delete(0, sBuilder.length());
                result = false;
                break;
            }
            readedOffset = curIndexOffset + 28;
            lastRdDataOffset = maxDataLimitOffset;
            ClientBroker.TransferedMessage transferedMessage = DataStoreUtils.getTransferMsg(dataBuffer, curIndexDataSize, countMap, statsKeyBase, sBuilder);
            if (transferedMessage == null) continue;
            transferedMessageList.add(transferedMessage);
            if ((totalSize += curIndexDataSize) >= maxMsgTransferSize) break;
        }
        if (recordSeg != null) {
            recordSeg.relViewRef();
        }
        if (retCode != 0 && !transferedMessageList.isEmpty()) {
            retCode = 0;
            errInfo = "Ok";
        }
        if (lastRdDataOffset <= 0L) {
            lastRdDataOffset = lastRdOffset;
        }
        return new GetMessageResult(result, retCode, errInfo, reqOffset, readedOffset, lastRdDataOffset, totalSize, countMap, transferedMessageList);
    }

    public long getStartOffsetByTimeStamp(long timestamp) {
        Segment recordSeg = this.indexSegments.findSegmentByTimeStamp(timestamp);
        if (recordSeg == null || this.closed.get()) {
            return -1L;
        }
        long endPos = (recordSeg.getCommitLast() - recordSeg.getStart()) / 28L - 1L;
        long curDataMinOffset = this.getDataMinOffset();
        ByteBuffer readBuffer = ByteBuffer.allocate(28);
        if (endPos <= 0L) {
            return recordSeg.getStart();
        }
        long foundTime = this.getTimeStamp(recordSeg, 0L, curDataMinOffset, readBuffer);
        if (timestamp < foundTime) {
            return recordSeg.getStart();
        }
        foundTime = this.getTimeStamp(recordSeg, endPos * 28L, curDataMinOffset, readBuffer);
        if (timestamp > foundTime) {
            return recordSeg.getStart() + endPos * 28L;
        }
        long midPos = 0L;
        long startPos = 0L;
        long firstLowPos = 0L;
        long firstEqualPos = -1L;
        while (startPos <= endPos) {
            midPos = endPos + startPos >>> 1;
            foundTime = this.getTimeStamp(recordSeg, midPos * 28L, curDataMinOffset, readBuffer);
            if (foundTime < timestamp) {
                firstLowPos = midPos;
                startPos = midPos + 1L;
                continue;
            }
            endPos = midPos - 1L;
            if (foundTime != timestamp) continue;
            firstEqualPos = midPos;
        }
        if (firstEqualPos != -1L) {
            return recordSeg.getStart() + firstEqualPos * 28L;
        }
        return recordSeg.getStart() + firstLowPos * 28L;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.writeLock.lock();
            try {
                this.indexSegments.close();
                this.dataSegments.close();
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public boolean runClearupPolicy(boolean onlyCheck) {
        StringBuilder sBuilder = new StringBuilder(512);
        long start = System.currentTimeMillis();
        boolean hasExpiredDataSegs = this.dataSegments.checkExpiredSegments(start, this.messageStore.getMaxFileValidDurMs());
        boolean hasExpiredIndexSegs = this.indexSegments.checkExpiredSegments(start, this.messageStore.getMaxFileValidDurMs());
        if (onlyCheck) {
            return hasExpiredDataSegs || hasExpiredIndexSegs;
        }
        if (hasExpiredDataSegs) {
            this.dataSegments.delExpiredSegments(sBuilder);
        }
        if (hasExpiredIndexSegs) {
            this.indexSegments.delExpiredSegments(sBuilder);
        }
        return hasExpiredDataSegs || hasExpiredIndexSegs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDiskFile() throws IOException {
        long checkTimestamp = System.currentTimeMillis();
        if (this.curUnflushed.get() > 0 && checkTimestamp - this.lastFlushTime.get() >= (long)this.messageStore.getUnflushInterval()) {
            long flushedMsgCnt = 0L;
            long flushedDataSize = 0L;
            boolean forceMetadata = false;
            this.writeLock.lock();
            try {
                checkTimestamp = System.currentTimeMillis();
                if (this.curUnflushed.get() >= 0 && checkTimestamp - this.lastFlushTime.get() >= (long)this.messageStore.getUnflushInterval()) {
                    forceMetadata = checkTimestamp - this.lastMetaFlushTime.get() > 3600000L;
                    this.dataSegments.flushLast(forceMetadata);
                    this.indexSegments.flushLast(forceMetadata);
                    if (forceMetadata) {
                        this.lastMetaFlushTime.set(checkTimestamp);
                    }
                    flushedMsgCnt = this.curUnflushed.getAndSet(0);
                    flushedDataSize = this.curUnflushSize.getAndSet(0L);
                    this.lastFlushTime.set(checkTimestamp);
                }
            }
            finally {
                this.writeLock.unlock();
                this.msgStoreStatsHolder.addFileTimeoutFlushStats(flushedMsgCnt, flushedDataSize, forceMetadata);
            }
        }
        this.msgStoreStatsHolder.chkStatsExpired(checkTimestamp);
    }

    public long getDataSizeInBytes() {
        return this.dataSegments.getSizeInBytes();
    }

    public long getIndexSizeInBytes() {
        return this.indexSegments.getSizeInBytes();
    }

    public long getDataMaxOffset() {
        return this.dataSegments.getMaxOffset();
    }

    public long getDataHighMaxOffset() {
        return this.dataSegments.getCommitMaxOffset();
    }

    public long getDataMinOffset() {
        return this.dataSegments.getMinOffset();
    }

    public long getIndexMaxOffset() {
        return this.indexSegments.getMaxOffset();
    }

    public long getIndexMaxAppendTime() {
        return this.indexSegments.getMaxAppendTime();
    }

    public long getIndexMaxHighOffset() {
        return this.indexSegments.getCommitMaxOffset();
    }

    public long getIndexMinOffset() {
        return this.indexSegments.getMinOffset();
    }

    public Segment indexSlice(long offset, int maxSize) throws IOException {
        return this.indexSegments.getRecordSeg(offset);
    }

    private void loadSegments(SegmentType segType, long offsetIfCreate, StringBuilder sBuilder) throws IOException {
        String segTypeStr = "Data";
        File segListDir = this.dataDir;
        String fileSuffix = ".tube";
        if (segType == SegmentType.INDEX) {
            segTypeStr = "Index";
            segListDir = this.indexDir;
            fileSuffix = ".index";
        }
        logger.info(sBuilder.append("[File Store] begin Load ").append(segTypeStr).append(" segments ").append(segListDir.getAbsolutePath()).toString());
        sBuilder.delete(0, sBuilder.length());
        ArrayList<Segment> accum = new ArrayList<Segment>();
        File[] ls = segListDir.listFiles();
        if (ls != null) {
            for (File file : ls) {
                if (file == null || !file.isFile() || !file.toString().endsWith(fileSuffix)) continue;
                if (!file.canRead()) {
                    throw new IOException(new StringBuilder(512).append("Could not read ").append(segTypeStr).append(" file ").append(file).toString());
                }
                String filename = file.getName();
                long start = Long.parseLong(filename.substring(0, filename.length() - fileSuffix.length()));
                accum.add(new FileSegment(start, file, false, segType));
            }
        }
        if (accum.size() == 0) {
            File newFile = new File(segListDir, DataStoreUtils.nameFromOffset(offsetIfCreate, fileSuffix));
            logger.info(sBuilder.append("[File Store] Created ").append(segTypeStr).append(" segment ").append(newFile.getAbsolutePath()).toString());
            sBuilder.delete(0, sBuilder.length());
            accum.add(new FileSegment(offsetIfCreate, newFile, segType));
        } else {
            accum.sort(new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return Long.compare(o1.getStart(), o2.getStart());
                }
            });
            this.validateSegments(segTypeStr, accum);
            Segment last = (Segment)accum.get(accum.size() - 1);
            if (last.getCachedSize() > 0L && System.currentTimeMillis() - last.getFile().lastModified() >= 172800000L) {
                long newOffset = last.getCommitLast();
                File newFile = new File(segListDir, DataStoreUtils.nameFromOffset(newOffset, fileSuffix));
                logger.info(sBuilder.append("[File Store] Created time roll").append(segTypeStr).append(" segment ").append(newFile.getAbsolutePath()).toString());
                sBuilder.delete(0, sBuilder.length());
                accum.add(new FileSegment(newOffset, newFile, segType));
            } else {
                last = (Segment)accum.remove(accum.size() - 1);
                last.close();
                logger.info(sBuilder.append("[File Store] Loading the last ").append(segTypeStr).append(" segment in mutable mode and running recover on ").append(last.getFile().getAbsolutePath()).toString());
                sBuilder.delete(0, sBuilder.length());
                FileSegment mutable = new FileSegment(last.getStart(), last.getFile(), segType, Long.MAX_VALUE);
                accum.add(mutable);
            }
        }
        if (segType == SegmentType.DATA) {
            this.dataSegments = new FileSegmentList(accum.toArray(new Segment[accum.size()]));
        } else {
            this.indexSegments = new FileSegmentList(accum.toArray(new Segment[accum.size()]));
        }
        logger.info(sBuilder.append("[File Store] Loaded ").append(segTypeStr).append(" ").append(accum.size()).append(" segments from ").append(segListDir.getAbsolutePath()).toString());
        sBuilder.delete(0, sBuilder.length());
    }

    private void validateSegments(String segTypeStr, List<Segment> segments) {
        for (int i = 0; i < segments.size() - 1; ++i) {
            Segment curr = segments.get(i);
            Segment next = segments.get(i + 1);
            if (curr.getStart() + curr.getCachedSize() == next.getStart()) continue;
            throw new IllegalStateException(new StringBuilder(512).append("The following ").append(segTypeStr).append(" segments don't validate: ").append(curr.getFile().getAbsolutePath()).append(", ").append(next.getFile().getAbsolutePath()).toString());
        }
    }

    private long getTimeStamp(Segment recordSeg, long relReadPos, long curDataMinOffset, ByteBuffer readBuffer) {
        int curIndexPartitionId = 0;
        long curIndexDataOffset = 0L;
        int curIndexDataSize = 0;
        int curIndexKeyCode = 0;
        long recvTimeInMillsec = 0L;
        try {
            readBuffer.clear();
            recordSeg.relRead(readBuffer, relReadPos);
            readBuffer.flip();
            curIndexPartitionId = readBuffer.getInt();
            curIndexDataOffset = readBuffer.getLong();
            curIndexDataSize = readBuffer.getInt();
            curIndexKeyCode = readBuffer.getInt();
            recvTimeInMillsec = readBuffer.getLong();
            if (curIndexDataOffset < 0L || curIndexDataSize <= 0 || curIndexDataSize > 29360180 || curIndexDataOffset < curDataMinOffset) {
                return -1L;
            }
            return recvTimeInMillsec;
        }
        catch (Throwable ex) {
            samplePrintCtrl.printExceptionCaught(ex);
            return -1L;
        }
    }
}

