/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.InlongGroupApproveForm;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.listener.group.apply.AfterApprovedTaskListener;
import org.apache.inlong.manager.service.listener.group.apply.ApproveApplyProcessListener;
import org.apache.inlong.manager.service.listener.group.apply.CancelApplyProcessListener;
import org.apache.inlong.manager.service.listener.group.apply.RejectApplyProcessListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplyGroupWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private CancelApplyProcessListener cancelApplyProcessListener;
    @Autowired
    private RejectApplyProcessListener rejectApplyProcessListener;
    @Autowired
    private ApproveApplyProcessListener approveApplyProcessListener;
    @Autowired
    private AfterApprovedTaskListener afterApprovedTaskListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(ApplyGroupProcessForm.class);
        process.setVersion(1);
        process.addListener((ProcessEventListener)this.cancelApplyProcessListener);
        process.addListener((ProcessEventListener)this.rejectApplyProcessListener);
        process.addListener((ProcessEventListener)this.approveApplyProcessListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("SystemAdmin");
        adminUserTask.setFormClass(InlongGroupApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.afterApprovedTaskListener);
        process.addTask((WorkflowTask)adminUserTask);
        startEvent.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.APPLY_GROUP_PROCESS;
    }

    private List<String> getTaskApprovers(String taskName) {
        return this.workflowApproverService.getApprovers(this.getProcessName().name(), taskName);
    }
}

