/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.stream;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TemplateVisibleRange;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.TemplateEntity;
import org.apache.inlong.manager.dao.entity.TemplateFieldEntity;
import org.apache.inlong.manager.dao.entity.TenantTemplateEntity;
import org.apache.inlong.manager.dao.mapper.TemplateEntityMapper;
import org.apache.inlong.manager.dao.mapper.TemplateFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.TenantTemplateEntityMapper;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.stream.TemplateField;
import org.apache.inlong.manager.pojo.stream.TemplateInfo;
import org.apache.inlong.manager.pojo.stream.TemplatePageRequest;
import org.apache.inlong.manager.pojo.stream.TemplateRequest;
import org.apache.inlong.manager.pojo.stream.TenantTemplateRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.stream.TemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    private TemplateEntityMapper templateEntityMapper;
    @Autowired
    private TemplateFieldEntityMapper templateFieldEntityMapper;
    @Autowired
    private TenantTemplateEntityMapper tenantTemplateEntityMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer save(TemplateRequest request, String operator) {
        LOGGER.debug("begin to save template info={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"inlong template info is empty");
        String templateName = request.getName();
        TemplateEntity existEntity = this.templateEntityMapper.selectByName(templateName);
        if (existEntity != null) {
            LOGGER.error("inlong template name [{}] has already exists", (Object)templateName);
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_NAME_DUPLICATE);
        }
        TemplateEntity templateEntity = (TemplateEntity)CommonBeanUtils.copyProperties((Object)request, TemplateEntity::new);
        templateEntity.setCreator(operator);
        templateEntity.setModifier(operator);
        this.templateEntityMapper.insert(templateEntity);
        request.setId(templateEntity.getId());
        this.saveField(request);
        if (CollectionUtils.isNotEmpty((Collection)request.getTenantList())) {
            TenantTemplateRequest tagRequest = new TenantTemplateRequest();
            tagRequest.setTemplateName(templateName);
            request.getTenantList().forEach(tenant -> {
                tagRequest.setTenant(tenant);
                this.saveTenantTemplate(tagRequest, operator);
            });
        }
        LOGGER.info("success to save inlong stream info for template name={}", (Object)templateName);
        return templateEntity.getId();
    }

    @Override
    public Boolean exist(String templateName) {
        Preconditions.expectNotBlank((String)templateName, (ErrorCodeEnum)ErrorCodeEnum.TEMPLATE_INFO_INCORRECT);
        TemplateEntity templateEntity = this.templateEntityMapper.selectByName(templateName);
        return templateEntity != null;
    }

    @Override
    public TemplateInfo get(String templateName, String operator) {
        LOGGER.debug("begin to get inlong template by template name={}", (Object)templateName);
        Preconditions.expectNotBlank((String)templateName, (ErrorCodeEnum)ErrorCodeEnum.TEMPLATE_INFO_INCORRECT);
        TemplateEntity templateEntity = this.templateEntityMapper.selectByName(templateName);
        if (templateEntity == null) {
            LOGGER.error("inlong template not found by template name={}", (Object)templateName);
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_NOT_FOUND);
        }
        TemplateInfo templateInfo = (TemplateInfo)CommonBeanUtils.copyProperties((Object)templateEntity, TemplateInfo::new);
        List<TemplateField> templateFields = this.getTemplateFields(templateEntity.getId());
        templateInfo.setFieldList(templateFields);
        List tenantTemplateEntities = this.tenantTemplateEntityMapper.selectByTemplateName(templateName);
        if (Objects.equals(templateEntity.getVisibleRange(), TemplateVisibleRange.TENANT.name()) && CollectionUtils.isNotEmpty((Collection)tenantTemplateEntities)) {
            List<String> tenantList = tenantTemplateEntities.stream().map(TenantTemplateEntity::getTenant).collect(Collectors.toList());
            this.checkVis(templateEntity, tenantList, operator);
            templateInfo.setTenantList(tenantList);
        }
        return templateInfo;
    }

    private void checkVis(TemplateEntity templateEntity, List<String> tenantList, String operator) {
        if (Objects.equals(templateEntity.getVisibleRange(), TemplateVisibleRange.IN_CHARGE.name()) && !templateEntity.getInCharges().contains(operator)) {
            throw new BusinessException("current user is not in charge");
        }
        if (Objects.equals(templateEntity.getVisibleRange(), TemplateVisibleRange.TENANT.name()) && !tenantList.contains(LoginUserUtils.getLoginUser().getTenant())) {
            throw new BusinessException("current user is not in tenant");
        }
    }

    @Override
    public PageResult<TemplateInfo> list(TemplatePageRequest request) {
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        Page entityPage = (Page)this.templateEntityMapper.selectByCondition(request);
        PageResult pageResult = PageResult.fromPage((Page)entityPage).map(entity -> {
            TemplateInfo response = (TemplateInfo)CommonBeanUtils.copyProperties((Object)entity, TemplateInfo::new);
            List tenantList = this.tenantTemplateEntityMapper.selectByTemplateName(entity.getName()).stream().map(TenantTemplateEntity::getTenant).collect(Collectors.toList());
            response.setTenantList(tenantList);
            return response;
        });
        LOGGER.debug("success to list template page, result size {}", (Object)pageResult.getList().size());
        return pageResult;
    }

    private List<TemplateField> getTemplateFields(Integer templateId) {
        List fieldEntityList = this.templateFieldEntityMapper.selectByTemplateId(templateId);
        if (CollectionUtils.isEmpty((Collection)fieldEntityList)) {
            return Collections.emptyList();
        }
        return CommonBeanUtils.copyListProperties((List)fieldEntityList, TemplateField::new);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean update(TemplateRequest request, String operator) {
        LOGGER.debug("begin to update inlong template, request={}", (Object)request);
        String templateName = request.getName();
        TemplateEntity templateEntity = this.templateEntityMapper.selectByName(templateName);
        if (templateEntity == null) {
            LOGGER.error("inlong template not found by template name={}", (Object)templateName);
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_NOT_FOUND);
        }
        if (!templateEntity.getInCharges().contains(operator)) {
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_PERMISSION_DENIED, String.format("user [%s] has no update privilege for the inlong temlate", operator));
        }
        String errMsg = String.format("template has already updated with template name=%s, curVersion=%s", templateEntity.getName(), request.getVersion());
        if (!Objects.equals(templateEntity.getVersion(), request.getVersion())) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        CommonBeanUtils.copyProperties((Object)request, (Object)templateEntity, (boolean)true);
        templateEntity.setModifier(operator);
        int rowCount = this.templateEntityMapper.updateByIdSelective(templateEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error(errMsg);
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateField(request);
        if (CollectionUtils.isNotEmpty((Collection)request.getTenantList())) {
            HashSet updatedTenants = new HashSet(request.getTenantList());
            List tenantList = this.tenantTemplateEntityMapper.selectByTemplateName(templateName);
            tenantList.stream().filter(entity -> !updatedTenants.contains(entity.getTenant())).forEach(entity -> {
                try {
                    this.deleteTenantTemplate(entity.getId(), operator);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            });
            Set currentTenants = tenantList.stream().map(TenantTemplateEntity::getTenant).collect(Collectors.toSet());
            TenantTemplateRequest tagRequest = new TenantTemplateRequest();
            tagRequest.setTemplateName(templateName);
            updatedTenants.stream().filter(tenant -> !currentTenants.contains(tenant)).forEach(tenant -> {
                try {
                    tagRequest.setTenant(tenant);
                    this.saveTenantTemplate(tagRequest, operator);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            });
        }
        LOGGER.info("success to update inlong template for template name={}", (Object)templateName);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(Integer id, String operator) {
        LOGGER.debug("begin to delete inlong template, Id={}", (Object)id);
        TemplateEntity entity = this.templateEntityMapper.selectByPrimaryKey(id);
        if (entity == null) {
            LOGGER.error("inlong template not found by template id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_NOT_FOUND);
        }
        if (!entity.getInCharges().contains(operator)) {
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_PERMISSION_DENIED, String.format("user [%s] has no delete privilege for the inlong template", operator));
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.templateEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("template has already updated with template id={}, curVersion={}", (Object)id, (Object)entity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("begin to delete inlong template field, templateId={}", (Object)id);
        this.templateFieldEntityMapper.logicDeleteAllByTemplateId(id);
        LOGGER.info("success to delete inlong template, fields for templateId={}", (Object)id);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Boolean delete(String templateName, String operator) {
        LOGGER.debug("begin to delete inlong template, template name={}", (Object)templateName);
        TemplateEntity entity = this.templateEntityMapper.selectByName(templateName);
        if (entity == null) {
            LOGGER.error("inlong template not found by template name={}", (Object)templateName);
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_NOT_FOUND);
        }
        if (!entity.getInCharges().contains(operator)) {
            throw new BusinessException(ErrorCodeEnum.TEMPLATE_PERMISSION_DENIED, String.format("user [%s] has no delete privilege for the inlong template", operator));
        }
        entity.setIsDeleted(entity.getId());
        entity.setModifier(operator);
        int rowCount = this.templateEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("template has already updated with template name={}, curVersion={}", (Object)templateName, (Object)entity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.debug("begin to delete inlong template field, templateId={}", (Object)templateName);
        this.templateFieldEntityMapper.logicDeleteAllByTemplateId(entity.getId());
        LOGGER.info("success to delete inlong template, fields for templateName={}", (Object)templateName);
        return true;
    }

    @Transactional(rollbackFor={Throwable.class})
    public void saveField(TemplateRequest request) {
        List fieldList = request.getFieldList();
        LOGGER.debug("begin to save template fields={}", (Object)fieldList);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            return;
        }
        int size = fieldList.size();
        ArrayList<TemplateFieldEntity> entityList = new ArrayList<TemplateFieldEntity>(size);
        Integer templateId = request.getId();
        for (TemplateField fieldInfo : fieldList) {
            TemplateFieldEntity fieldEntity = (TemplateFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, TemplateFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setTemplateId(templateId);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.templateFieldEntityMapper.insertAll(entityList);
        LOGGER.debug("success to save sink fields");
    }

    @Transactional(rollbackFor={Throwable.class})
    public void updateField(TemplateRequest request) {
        Integer templateId = request.getId();
        List fieldRequestList = request.getFieldList();
        if (CollectionUtils.isEmpty((Collection)fieldRequestList)) {
            return;
        }
        this.templateFieldEntityMapper.deleteAllByTemplateId(templateId);
        this.saveField(request);
        LOGGER.info("success to update template field");
    }

    public Integer saveTenantTemplate(TenantTemplateRequest request, String operator) {
        LOGGER.debug("begin to save tenant template {}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"tenant cluster request cannot be empty");
        Preconditions.expectNotBlank((String)request.getTemplateName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"template name cannot be empty");
        Preconditions.expectNotBlank((String)request.getTenant(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"tenant cannot be empty");
        TenantTemplateEntity entity = (TenantTemplateEntity)CommonBeanUtils.copyProperties((Object)request, TenantTemplateEntity::new);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.tenantTemplateEntityMapper.insert(entity);
        LOGGER.info("success to save tenant tag, tenant={}, template name={}", (Object)request.getTenant(), (Object)request.getTemplateName());
        return entity.getId();
    }

    public Boolean deleteTenantTemplate(Integer id, String operator) {
        LOGGER.debug("start to delete tenant template with id={}", (Object)id);
        TenantTemplateEntity entity = this.tenantTemplateEntityMapper.selectByPrimaryKey(id);
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.RECORD_NOT_FOUND.getMessage());
        entity.setModifier(operator);
        entity.setIsDeleted(id);
        int rowCount = this.tenantTemplateEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("tenant template has already deleted for tenant={} tag={}", (Object)entity.getTenant(), (Object)entity.getTemplateName());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete tenant template of tenant={} tag={}, user={}", new Object[]{entity.getTenant(), entity.getTemplateName(), operator});
        return true;
    }
}

