/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.oracle;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.oracle.OracleColumnInfo;
import org.apache.inlong.manager.pojo.sink.oracle.OracleSinkDTO;
import org.apache.inlong.manager.pojo.sink.oracle.OracleTableInfo;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.oracle.OracleJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OracleResourceOperator
implements SinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(OracleResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper fieldEntityMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "ORACLE".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create Oracle resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("Oracle resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOG.info("begin to create Oracle table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.fieldEntityMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOG.warn("no Oracle fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<OracleColumnInfo> columnList = new ArrayList<OracleColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            OracleColumnInfo columnInfo = new OracleColumnInfo(field.getFieldName(), field.getFieldType(), field.getFieldComment());
            columnList.add(columnInfo);
        }
        OracleSinkDTO oracleSink = OracleSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        OracleTableInfo tableInfo = OracleSinkDTO.getTableInfo((OracleSinkDTO)oracleSink, columnList);
        try (Connection conn = OracleJdbcUtils.getConnection(oracleSink.getJdbcUrl(), oracleSink.getUsername(), oracleSink.getPassword());){
            OracleJdbcUtils.createTable(conn, tableInfo);
            OracleJdbcUtils.addColumns(conn, tableInfo.getTableName(), columnList);
            String info = "success to create Oracle resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), "success to create Oracle resource");
            LOG.info("success to create Oracle resource for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create Oracle table failed: " + e.getMessage();
            LOG.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOG.info("success create Oracle table for data sink [" + sinkInfo.getId() + "]");
    }
}

