/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.oceanbase;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.oceanbase.OceanBaseDataNodeDTO;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseColumnInfo;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseSinkDTO;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.oceanbase.OceanBaseJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OceanBaseResourceOperator
implements SinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(OceanBaseResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper fieldEntityMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "OCEANBASE".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create OceanBase resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("OceanBase resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOG.info("begin to create OceanBase table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.fieldEntityMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOG.warn("no OceanBase fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<OceanBaseColumnInfo> columnList = new ArrayList<OceanBaseColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            OceanBaseColumnInfo columnInfo = new OceanBaseColumnInfo(field.getFieldName(), field.getFieldType(), field.getFieldComment());
            columnList.add(columnInfo);
        }
        OceanBaseSinkDTO sinkDTO = this.getOceanBaseInfo(sinkInfo);
        OceanBaseTableInfo tableInfo = OceanBaseSinkDTO.getTableInfo((OceanBaseSinkDTO)sinkDTO, columnList);
        try (Connection conn = OceanBaseJdbcUtils.getConnection(sinkDTO.getJdbcUrl(), sinkDTO.getUsername(), sinkDTO.getPassword());){
            OceanBaseJdbcUtils.createDb(conn, tableInfo.getDbName());
            OceanBaseJdbcUtils.createTable(conn, tableInfo);
            OceanBaseJdbcUtils.addColumns(conn, tableInfo.getDbName(), tableInfo.getTableName(), columnList);
            String info = "success to create OceanBase resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOG.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create OceanBase table failed: " + e.getMessage();
            LOG.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOG.info("success create OceanBase table for data sink [" + sinkInfo.getId() + "]");
    }

    private OceanBaseSinkDTO getOceanBaseInfo(SinkInfo sinkInfo) {
        OceanBaseSinkDTO OceanBaseInfo = OceanBaseSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        if (StringUtils.isBlank((CharSequence)OceanBaseInfo.getJdbcUrl())) {
            String dataNodeName = sinkInfo.getDataNodeName();
            Preconditions.expectNotBlank((String)dataNodeName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"OceanBase jdbc url not specified and data node is empty");
            DataNodeInfo dataNodeInfo = this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)OceanBaseInfo);
            OceanBaseInfo.setJdbcUrl(OceanBaseDataNodeDTO.convertToJdbcurl((String)dataNodeInfo.getUrl()));
            OceanBaseInfo.setPassword(dataNodeInfo.getToken());
        }
        return OceanBaseInfo;
    }
}

