/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.postgresql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.postgresql.PostgreSQLDataNodeDTO;
import org.apache.inlong.manager.pojo.node.postgresql.PostgreSQLDataNodeInfo;
import org.apache.inlong.manager.pojo.node.postgresql.PostgreSQLDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.postgresql.PostgreSQLJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostgreSQLDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "POSTGRESQL";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        PostgreSQLDataNodeInfo dataNodeInfo = new PostgreSQLDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)dataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            PostgreSQLDataNodeDTO dto = PostgreSQLDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)dataNodeInfo);
        }
        return dataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        PostgreSQLDataNodeRequest nodeRequest = (PostgreSQLDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)nodeRequest, (Object)targetEntity, (boolean)true);
        try {
            PostgreSQLDataNodeDTO dto = PostgreSQLDataNodeDTO.getFromRequest((PostgreSQLDataNodeRequest)nodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for PostgreSQL node: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(DataNodeRequest request) {
        String jdbcUrl = PostgreSQLDataNodeDTO.convertToJdbcUrl((String)request.getUrl());
        String username = request.getUsername();
        String password = request.getToken();
        Preconditions.expectNotBlank((String)jdbcUrl, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection jdbcUrl cannot be empty");
        try (Connection ignored = PostgreSQLJdbcUtils.getConnection(jdbcUrl, username, password);){
            LOGGER.info("postgresql connection not null - connection success for jdbcUrl={}, username={}, password={}", new Object[]{jdbcUrl, username, password});
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("postgresql connection failed for jdbcUrl=%s, username=%s, password=%s", jdbcUrl, username, password);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }
}

