/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.maintenanceTools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.consume.SortConsumerInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.maintenanceTools.MaintenanceToolsService;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MaintenanceToolsServiceImpl
implements MaintenanceToolsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaintenanceToolsServiceImpl.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private InlongStreamEntityMapper streamEntityMapper;
    @Autowired
    private QueueResourceOperatorFactory queueOperatorFactory;

    /*
     * Exception decompiling
     */
    @Override
    public List<SortConsumerInfo> getSortConsumer(MultipartFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Boolean resetCursor(MultipartFile file, String resetTime) {
        LoginUserUtils.getLoginUser().getRoles().add("INLONG_SERVICE");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(resetTime);
            long timeStamp = date.getTime();
            String readerStr = null;
            while ((readerStr = bufferedReader.readLine()) != null) {
                String[] sinkIdList;
                for (String sinkIdStr : sinkIdList = readerStr.split(",")) {
                    Integer sinkId = Integer.valueOf(sinkIdStr);
                    StreamSinkEntity sinkEntity = this.sinkEntityMapper.selectByPrimaryKey(sinkId);
                    InlongGroupInfo groupInfo = this.groupService.get(sinkEntity.getInlongGroupId());
                    InlongPulsarInfo pulsarInfo = (InlongPulsarInfo)groupInfo;
                    InlongStreamEntity streamEntity = this.streamEntityMapper.selectByIdentifier(sinkEntity.getInlongGroupId(), sinkEntity.getInlongStreamId());
                    QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupInfo.getMqType());
                    queueOperator.resetCursor(groupInfo, streamEntity, sinkEntity, timeStamp);
                }
            }
            LOGGER.info("success reset cursor consumer");
        }
        catch (Exception e) {
            LOGGER.error("reset cursor consumer failed:", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Can not properly read update file");
        }
        return true;
    }
}

