/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sort;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperator;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperatorFactory;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamSortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSortConfigListener.class);
    @Autowired
    private SortConfigOperatorFactory operatorFactory;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String className = processForm.getClass().getSimpleName();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof StreamResourceProcessForm) {
            LOGGER.info("accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
            return true;
        }
        LOGGER.info("not accept sort config listener as the process is {} for groupId [{}]", (Object)className, (Object)groupId);
        return false;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            String msg = "inlong group not found with groupId=" + groupId;
            LOGGER.error(msg);
            throw new WorkflowListenerException(msg);
        }
        form.setGroupInfo(groupInfo);
        form.setStreamInfo(this.streamService.get(groupId, streamId));
        groupInfo = form.getGroupInfo();
        streamInfo = form.getStreamInfo();
        LOGGER.info("begin to build sort config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        GroupOperateType operateType = form.getGroupOperateType();
        if (operateType == GroupOperateType.SUSPEND || operateType == GroupOperateType.DELETE) {
            LOGGER.info("not build sort config for groupId={}, streamId={}, as the group operate type={}", new Object[]{groupId, streamId, operateType});
            return ListenerResult.success();
        }
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        Preconditions.expectTrue((GroupStatus.CONFIG_FAILED != groupStatus ? 1 : 0) != 0, (String)String.format("group status=%s not support start stream for groupId=%s", groupStatus, groupId));
        List streamSinks = streamInfo.getSinkList();
        if (CollectionUtils.isEmpty((Collection)streamSinks)) {
            LOGGER.warn("not build sort config for groupId={}, streamId={}, as not found any sinks", (Object)groupId, (Object)streamId);
            return ListenerResult.success();
        }
        try {
            List<String> sinkTypeList = streamSinks.stream().map(StreamSink::getSinkType).collect(Collectors.toList());
            List<SortConfigOperator> operatorList = this.operatorFactory.getInstance(sinkTypeList);
            for (SortConfigOperator operator : operatorList) {
                operator.buildConfig(groupInfo, streamInfo, InlongConstants.SYNC_SEND.equals(groupInfo.getInlongGroupMode()));
            }
        }
        catch (Exception e) {
            String msg = String.format("failed to build sort config for groupId=%s, streamId=%s, ", groupId, streamId);
            LOGGER.error(msg + "streamInfo=" + streamInfo, (Throwable)e);
            throw new WorkflowListenerException(msg + e.getMessage());
        }
        LOGGER.info("success to build sort config for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        return ListenerResult.success();
    }
}

