/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.datatype;

import java.util.List;
import java.util.Map;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.pojo.sort.dataflow.dataType.DataTypeConfig;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.consume.BriefMQMessage;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;

public interface DataTypeOperator {
    public boolean accept(DataTypeEnum var1);

    default public List<BriefMQMessage.FieldInfo> parseFields(String message, InlongStreamInfo streamInfo) throws Exception {
        return CommonBeanUtils.copyListProperties((List)streamInfo.getFieldList(), BriefMQMessage.FieldInfo::new);
    }

    default public DataTypeConfig getDataTypeConfig(InlongStreamInfo streamInfo) {
        throw new BusinessException(String.format("current type is not support for data type=%s", streamInfo.getDataType()));
    }

    default public Map<String, Object> parseTransform(InlongStreamInfo streamInfo, List<SinkField> fieldList, String transformSql, String data) {
        throw new BusinessException(String.format("current type is not support for data type=%s", streamInfo.getDataType()));
    }
}

