/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.consume;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.pojo.consume.kafka.ConsumeKafkaDTO;
import org.apache.inlong.manager.pojo.consume.kafka.ConsumeKafkaInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaTopicInfo;
import org.apache.inlong.manager.service.consume.AbstractConsumeOperator;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumeKafkaOperator
extends AbstractConsumeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeKafkaOperator.class);
    @Autowired
    private InlongGroupService groupService;

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType);
    }

    @Override
    public String getMQType() {
        return "KAFKA";
    }

    @Override
    public void checkTopicInfo(InlongConsumeRequest request) {
        String groupId = request.getInlongGroupId();
        InlongGroupTopicInfo topicInfo = this.groupService.getTopic(groupId);
        Preconditions.expectNotNull((Object)topicInfo, (String)("inlong group not exist: " + groupId));
        InlongKafkaTopicInfo kafkaInfo = (InlongKafkaTopicInfo)topicInfo;
        String originTopic = request.getTopic();
        Preconditions.expectTrue((boolean)kafkaInfo.getTopics().contains(originTopic), (String)("Kafka topic not exist for " + originTopic));
    }

    @Override
    public InlongConsumeInfo getFromEntity(InlongConsumeEntity entity) {
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.CONSUME_NOT_FOUND.getMessage());
        ConsumeKafkaInfo kafkaInfo = new ConsumeKafkaInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)kafkaInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ConsumeKafkaDTO dto = ConsumeKafkaDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)kafkaInfo);
        }
        return kafkaInfo;
    }

    @Override
    protected void setTargetEntity(InlongConsumeRequest request, InlongConsumeEntity targetEntity) {
        LOGGER.info("do nothing for inlong consume with Kafka");
    }
}

