/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.pojo.sink.hdfs.HDFSSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.FileSystemLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.stereotype.Service;

@Service
public class HDFSProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "HDFS".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        HDFSSink hdfsSink = (HDFSSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(hdfsSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(hdfsSink.getSinkFieldList(), hdfsSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(hdfsSink.getSinkFieldList(), constantFieldMap);
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(hdfsSink.getPartitionFieldList())) {
            partitionFields = hdfsSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), hdfsSink.getSinkName(), FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new FileSystemLoadNode(hdfsSink.getSinkName(), hdfsSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), hdfsSink.getDataPath(), hdfsSink.getFileFormat(), null, properties, (List)partitionFields, hdfsSink.getServerTimeZone());
    }
}

