/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.oceanbase;

import com.google.common.base.Strings;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseColumnInfo;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseSinkRequest;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OceanBaseSinkDTO
extends BaseStreamSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(OceanBaseSinkDTO.class);
    private static final String OCEANBASE_JDBC_PREFIX = "jdbc:oceanbase://";
    private static final String OCEANBASE_JDBC_PREFIX_CDC = "jdbc:mysql://";
    @ApiModelProperty(value="OceanBase JDBC URL, such as jdbc:oceanbase://host:port")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String databaseName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for OceanBase")
    private Map<String, Object> properties;

    public static OceanBaseSinkDTO getFromRequest(OceanBaseSinkRequest request, String extParams) {
        OceanBaseSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? OceanBaseSinkDTO.getFromJson(extParams) : new OceanBaseSinkDTO();
        CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
        return dto;
    }

    public static OceanBaseSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (OceanBaseSinkDTO)JsonUtils.parseObject((String)extParams, OceanBaseSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of OceanBase SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static OceanBaseTableInfo getTableInfo(OceanBaseSinkDTO OceanBaseSink2, List<OceanBaseColumnInfo> columnList) {
        OceanBaseTableInfo tableInfo = new OceanBaseTableInfo();
        tableInfo.setDbName(OceanBaseSink2.getDatabaseName());
        tableInfo.setTableName(OceanBaseSink2.getTableName());
        tableInfo.setPrimaryKey(OceanBaseSink2.getPrimaryKey());
        tableInfo.setColumns(columnList);
        return tableInfo;
    }

    private static String getDbNameFromUrl(String jdbcUrl) {
        int pos1;
        String database = null;
        if (Strings.isNullOrEmpty((String)jdbcUrl)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:impala")) {
            jdbcUrl = jdbcUrl.replace(":impala", "");
        }
        if (!jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String connUri = jdbcUrl.substring(pos1 + 1);
        if (connUri.startsWith("//")) {
            int pos = connUri.indexOf(47, 2);
            if (pos != -1) {
                database = connUri.substring(pos + 1);
            }
        } else {
            database = connUri;
        }
        if (Strings.isNullOrEmpty((String)database)) {
            throw new IllegalArgumentException("Invalid JDBC URL: " + jdbcUrl);
        }
        if (database.contains("?")) {
            database = database.substring(0, database.indexOf("?"));
        }
        if (database.contains(";")) {
            database = database.substring(0, database.indexOf(";"));
        }
        return database;
    }

    public static String setDbNameToUrl(String jdbcUrl, String databaseName) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            return jdbcUrl;
        }
        String pattern = "jdbc:oceanbase://(?<host>[a-zA-Z0-9-//.]+):(?<port>[0-9]+)?(?<ext>)";
        Pattern namePattern = Pattern.compile(pattern);
        Matcher dataMatcher = namePattern.matcher(jdbcUrl);
        if (!dataMatcher.find()) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "OceanBase JDBC URL was invalid, it should like jdbc:mysql://host:port");
        }
        String host = dataMatcher.group("host");
        String port = dataMatcher.group("port");
        StringBuilder resultUrl = new StringBuilder().append(OCEANBASE_JDBC_PREFIX).append(host).append(":").append(port).append("/").append(databaseName);
        if (jdbcUrl.contains("?")) {
            resultUrl.append(jdbcUrl.substring(jdbcUrl.indexOf("?")));
        }
        return resultUrl.toString();
    }

    public static String setDbNameToUrlWithCdc(String jdbcUrl, String databaseName) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            return jdbcUrl;
        }
        String pattern = "jdbc:oceanbase://(?<host>[a-zA-Z0-9-//.]+):(?<port>[0-9]+)?(?<ext>)";
        Pattern namePattern = Pattern.compile(pattern);
        Matcher dataMatcher = namePattern.matcher(jdbcUrl);
        if (!dataMatcher.find()) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "OceanBase JDBC URL was invalid, it should like jdbc:mysql://host:port");
        }
        String host = dataMatcher.group("host");
        String port = dataMatcher.group("port");
        StringBuilder resultUrl = new StringBuilder().append(OCEANBASE_JDBC_PREFIX_CDC).append(host).append(":").append(port).append("/").append(databaseName);
        if (jdbcUrl.contains("?")) {
            resultUrl.append(jdbcUrl.substring(jdbcUrl.indexOf("?")));
        }
        return resultUrl.toString();
    }

    public static OceanBaseSinkDTOBuilder builder() {
        return new OceanBaseSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OceanBaseSinkDTO)) {
            return false;
        }
        OceanBaseSinkDTO other = (OceanBaseSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OceanBaseSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OceanBaseSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public OceanBaseSinkDTO() {
    }

    public OceanBaseSinkDTO(String jdbcUrl, String username, String password, String databaseName, String tableName, String primaryKey, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class OceanBaseSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String databaseName;
        private String tableName;
        private String primaryKey;
        private Map<String, Object> properties;

        OceanBaseSinkDTOBuilder() {
        }

        public OceanBaseSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public OceanBaseSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OceanBaseSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OceanBaseSinkDTOBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public OceanBaseSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public OceanBaseSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public OceanBaseSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public OceanBaseSinkDTO build() {
            return new OceanBaseSinkDTO(this.jdbcUrl, this.username, this.password, this.databaseName, this.tableName, this.primaryKey, this.properties);
        }

        public String toString() {
            return "OceanBaseSinkDTO.OceanBaseSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

