/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.http;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.http.HttpSinkRequest;

public class HttpSinkDTO
extends BaseStreamSink {
    @ApiModelProperty(value="HTTP path")
    private String path;
    @ApiModelProperty(value="HTTP method, like POST, GET")
    private String method;
    @ApiModelProperty(value="HTTP headers")
    private Map<String, String> headers;
    @ApiModelProperty(value="Max retry times")
    private Integer maxRetryTimes;

    public static HttpSinkDTO getFromRequest(HttpSinkRequest request, String extParams) {
        HttpSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? HttpSinkDTO.getFromJson(extParams) : new HttpSinkDTO();
        return (HttpSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static HttpSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (HttpSinkDTO)JsonUtils.parseObject((String)extParams, HttpSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of http SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static HttpSinkDTOBuilder builder() {
        return new HttpSinkDTOBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Integer getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setMaxRetryTimes(Integer maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSinkDTO)) {
            return false;
        }
        HttpSinkDTO other = (HttpSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxRetryTimes = this.getMaxRetryTimes();
        Integer other$maxRetryTimes = other.getMaxRetryTimes();
        if (this$maxRetryTimes == null ? other$maxRetryTimes != null : !((Object)this$maxRetryTimes).equals(other$maxRetryTimes)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxRetryTimes = this.getMaxRetryTimes();
        result = result * 59 + ($maxRetryTimes == null ? 43 : ((Object)$maxRetryTimes).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HttpSinkDTO(path=" + this.getPath() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ", maxRetryTimes=" + this.getMaxRetryTimes() + ")";
    }

    public HttpSinkDTO() {
    }

    public HttpSinkDTO(String path, String method, Map<String, String> headers, Integer maxRetryTimes) {
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.maxRetryTimes = maxRetryTimes;
    }

    public static class HttpSinkDTOBuilder {
        private String path;
        private String method;
        private Map<String, String> headers;
        private Integer maxRetryTimes;

        HttpSinkDTOBuilder() {
        }

        public HttpSinkDTOBuilder path(String path) {
            this.path = path;
            return this;
        }

        public HttpSinkDTOBuilder method(String method) {
            this.method = method;
            return this;
        }

        public HttpSinkDTOBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpSinkDTOBuilder maxRetryTimes(Integer maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public HttpSinkDTO build() {
            return new HttpSinkDTO(this.path, this.method, this.headers, this.maxRetryTimes);
        }

        public String toString() {
            return "HttpSinkDTO.HttpSinkDTOBuilder(path=" + this.path + ", method=" + this.method + ", headers=" + this.headers + ", maxRetryTimes=" + this.maxRetryTimes + ")";
        }
    }
}

