/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.transform.DeleteTransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformFunctionDocRequest;
import org.apache.inlong.manager.pojo.transform.TransformFunctionDocResponse;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.apache.inlong.manager.service.transform.TransformFunctionDocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-StreamTransform-API"})
public class OpenStreamTransformController {
    @Autowired
    protected StreamTransformService streamTransformService;
    @Resource
    private TransformFunctionDocService transformFunctionDocService;

    @RequestMapping(value={"/transform/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Get stream transform list")
    public Response<List<TransformResponse>> list(@RequestParam(value="inlongGroupId") String groupId, @RequestParam(value="inlongStreamId") String streamId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"groupId cannot be blank");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.streamTransformService.listTransform(groupId, streamId));
    }

    @RequestMapping(value={"/transform/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Save stream transform")
    public Response<Integer> save(@Validated @RequestBody TransformRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.streamTransformService.save(request, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/transform/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Update stream transform")
    public Response<Boolean> update(@Validated(value={UpdateValidation.class}) @RequestBody TransformRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.streamTransformService.update(request, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/transform/delete"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.STREAM)
    @ApiOperation(value="Delete stream transform")
    public Response<Boolean> delete(@Validated DeleteTransformRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.streamTransformService.delete(request, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/transform/function/list"}, method={RequestMethod.POST})
    @ApiOperation(value="Get transform function docs list with optional type filtering and pagination")
    public Response<PageResult<TransformFunctionDocResponse>> listDocs(@Validated @RequestBody TransformFunctionDocRequest request) {
        return Response.success((Object)this.transformFunctionDocService.listByCondition(request));
    }

    @RequestMapping(value={"/transform/parseTransformSql"}, method={RequestMethod.POST})
    @ApiOperation(value="Parse stream transform sql")
    public Response<String> parseTransformSql(@Validated @RequestBody TransformRequest request) {
        return Response.success((Object)this.streamTransformService.parseTransformSql(request, LoginUserUtils.getLoginUser().getName()));
    }
}

