/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static Date getExpirationDate(Integer afterDays) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, afterDays);
        return cal.getTime();
    }

    public static Integer getValidDays(Date begin, Date end) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate createLocalDate = begin.toInstant().atZone(zoneId).toLocalDate();
        LocalDate dueLocalDate = end.toInstant().atZone(zoneId).toLocalDate();
        return Math.toIntExact(dueLocalDate.toEpochDay() - createLocalDate.toEpochDay());
    }

    private DateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

