/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.fieldtype.strategy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.fieldtype.FieldTypeMappingReader;
import org.apache.inlong.manager.common.fieldtype.strategy.DefaultFieldTypeStrategy;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseFieldTypeStrategy
extends DefaultFieldTypeStrategy {
    private final FieldTypeMappingReader reader = new FieldTypeMappingReader("CLICKHOUSE");
    private static final String NULLABLE_PATTERN = "^NULLABLE\\((.*)\\)$";
    private static final Pattern PATTERN = Pattern.compile("^NULLABLE\\((.*)\\)$");

    @Override
    public Boolean accept(String type) {
        return "CLICKHOUSE".equals(type);
    }

    @Override
    public String getSourceToSinkFieldTypeMapping(String sourceType) {
        Matcher matcher;
        if (StringUtils.isNotBlank((CharSequence)sourceType) && (matcher = PATTERN.matcher(sourceType.toUpperCase())).matches()) {
            sourceType = matcher.group(1);
        }
        String dataType = StringUtils.substringBefore((String)sourceType, (String)"(").toUpperCase();
        return this.reader.getSourceToSinkFieldTypeMap().getOrDefault(dataType, sourceType.toUpperCase());
    }
}

