/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.inlong.tubemq.corerpc.RpcDataPack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProtocolEncoder
extends MessageToMessageEncoder<RpcDataPack> {
    private static final Logger logger = LoggerFactory.getLogger(NettyProtocolEncoder.class);

    protected void encode(ChannelHandlerContext chx, RpcDataPack msg, List<Object> out) {
        RpcDataPack dataPack = msg;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            byteOut.write(this.getPackHeader(dataPack).array());
            List<ByteBuffer> origs = dataPack.getDataLst();
            for (ByteBuffer entry : origs) {
                byteOut.write(this.getLengthHeader(entry).array());
                byteOut.write(this.getLengthBody(entry));
            }
            byte[] body = byteOut.toByteArray();
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(body.length);
            buf.writeBytes(body);
            out.add(buf);
        }
        catch (IOException e) {
            logger.error("encode has exception ", (Throwable)e);
        }
    }

    private ByteBuffer getPackHeader(RpcDataPack dataPack) {
        ByteBuffer header = ByteBuffer.allocate(12);
        header.putInt(-8391426);
        header.putInt(dataPack.getSerialNo());
        header.putInt(dataPack.getDataLst().size());
        header.flip();
        return header;
    }

    private ByteBuffer getLengthHeader(ByteBuffer buf) {
        ByteBuffer header = ByteBuffer.allocate(4);
        header.putInt(buf.limit());
        header.flip();
        return header;
    }

    private byte[] getLengthBody(ByteBuffer buf) {
        return Arrays.copyOf(buf.array(), buf.limit());
    }
}

