/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.metric;

import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.audit.service.metric.MetricStat;

public class MetricItem {
    private static final String METRIC_ITEM_SPLITERATOR = ";";
    private AtomicLong inLongGroupIdNum = new AtomicLong(0L);
    private AtomicLong inLongStreamIdNum = new AtomicLong(0L);
    private ConcurrentHashMap<String, MetricStat> metricStatMap = new ConcurrentHashMap();

    public void resetAllMetrics() {
        for (MetricStat entry : this.metricStatMap.values()) {
            entry.getCount().set(0L);
            entry.getDuration().set(0L);
        }
    }

    public MetricStat getMetricStat(String metricName) {
        return this.metricStatMap.computeIfAbsent(metricName, k -> new MetricStat(new AtomicLong(), new AtomicLong()));
    }

    public ConcurrentHashMap<String, MetricStat> getMetricStatMap() {
        return this.metricStatMap;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(METRIC_ITEM_SPLITERATOR);
        for (Map.Entry entry : this.metricStatMap.entrySet()) {
            String stat = (String)entry.getKey() + "[" + entry.getValue() + "]";
            joiner.add(stat);
        }
        return joiner.toString();
    }

    public AtomicLong getInLongGroupIdNum() {
        return this.inLongGroupIdNum;
    }

    public AtomicLong getInLongStreamIdNum() {
        return this.inLongStreamIdNum;
    }

    public void setInLongGroupIdNum(AtomicLong inLongGroupIdNum) {
        this.inLongGroupIdNum = inLongGroupIdNum;
    }

    public void setInLongStreamIdNum(AtomicLong inLongStreamIdNum) {
        this.inLongStreamIdNum = inLongStreamIdNum;
    }

    public void setMetricStatMap(ConcurrentHashMap<String, MetricStat> metricStatMap) {
        this.metricStatMap = metricStatMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricItem)) {
            return false;
        }
        MetricItem other = (MetricItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AtomicLong this$inLongGroupIdNum = this.getInLongGroupIdNum();
        AtomicLong other$inLongGroupIdNum = other.getInLongGroupIdNum();
        if (this$inLongGroupIdNum == null ? other$inLongGroupIdNum != null : !this$inLongGroupIdNum.equals(other$inLongGroupIdNum)) {
            return false;
        }
        AtomicLong this$inLongStreamIdNum = this.getInLongStreamIdNum();
        AtomicLong other$inLongStreamIdNum = other.getInLongStreamIdNum();
        if (this$inLongStreamIdNum == null ? other$inLongStreamIdNum != null : !this$inLongStreamIdNum.equals(other$inLongStreamIdNum)) {
            return false;
        }
        ConcurrentHashMap this$metricStatMap = this.getMetricStatMap();
        ConcurrentHashMap other$metricStatMap = other.getMetricStatMap();
        return !(this$metricStatMap == null ? other$metricStatMap != null : !((Object)this$metricStatMap).equals(other$metricStatMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicLong $inLongGroupIdNum = this.getInLongGroupIdNum();
        result = result * 59 + ($inLongGroupIdNum == null ? 43 : $inLongGroupIdNum.hashCode());
        AtomicLong $inLongStreamIdNum = this.getInLongStreamIdNum();
        result = result * 59 + ($inLongStreamIdNum == null ? 43 : $inLongStreamIdNum.hashCode());
        ConcurrentHashMap $metricStatMap = this.getMetricStatMap();
        result = result * 59 + ($metricStatMap == null ? 43 : ((Object)$metricStatMap).hashCode());
        return result;
    }
}

