/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.deserialization;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.constant.Constant;
import org.apache.inlong.sort.protocol.deserialization.InLongMsgDeserializationInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InLongMsgCsvDeserializationInfo
extends InLongMsgDeserializationInfo {
    private static final long serialVersionUID = 1499370571949888870L;
    private final char delimiter;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    private final Character escapeChar;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final boolean deleteHeadDelimiter;
    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    private final Boolean deleteEscapeCharWhileDes;
    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    private final Boolean autoAppendEscapeCharAfterDes;

    public InLongMsgCsvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="delimiter") char delimiter) {
        this(streamId, delimiter, null, false);
    }

    public InLongMsgCsvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="delimiter") char delimiter, @JsonProperty(value="delete_head_delimiter") boolean deleteHeadDelimiter) {
        this(streamId, delimiter, null, deleteHeadDelimiter);
    }

    @JsonCreator
    public InLongMsgCsvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="delimiter") char delimiter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="delete_head_delimiter") boolean deleteHeadDelimiter) {
        this(streamId, delimiter, escapeChar, deleteHeadDelimiter, Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT, Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT);
    }

    @JsonCreator
    public InLongMsgCsvDeserializationInfo(@JsonProperty(value="streamId") @JsonAlias(value={"tid"}) String streamId, @JsonProperty(value="delimiter") char delimiter, @JsonProperty(value="escape_char") @Nullable Character escapeChar, @JsonProperty(value="delete_head_delimiter") boolean deleteHeadDelimiter, @JsonProperty(value="delete_escape_char_while_deserialize") @Nullable Boolean deleteEscapeCharWhileDes, @JsonProperty(value="auto_append_escape_char_after_deserialize") @Nullable Boolean autoAppendEscapeCharAfterDes) {
        super(streamId);
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.deleteHeadDelimiter = deleteHeadDelimiter;
        this.deleteEscapeCharWhileDes = deleteEscapeCharWhileDes;
        this.autoAppendEscapeCharAfterDes = autoAppendEscapeCharAfterDes;
    }

    @JsonProperty(value="delimiter")
    public char getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="escape_char")
    @Nullable
    public Character getEscapeChar() {
        return this.escapeChar;
    }

    @JsonProperty(value="delete_head_delimiter")
    public boolean isDeleteHeadDelimiter() {
        return this.deleteHeadDelimiter;
    }

    @JsonProperty(value="delete_escape_char_while_deserialize")
    @Nullable
    public Boolean getDeleteEscapeCharWhileDes() {
        if (this.deleteEscapeCharWhileDes != null) {
            return this.deleteEscapeCharWhileDes;
        }
        return Constant.DELETE_ESCAPE_CHAR_WHILE_DESERIALIZE_DEFAULT;
    }

    @JsonProperty(value="auto_append_escape_char_after_deserialize")
    @Nullable
    public Boolean getAutoAppendEscapeCharAfterDes() {
        if (this.autoAppendEscapeCharAfterDes != null) {
            return this.autoAppendEscapeCharAfterDes;
        }
        return Constant.AUTO_APPEND_ESCAPE_CHAR_AFTER_DESERIALIZE_DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InLongMsgCsvDeserializationInfo other = (InLongMsgCsvDeserializationInfo)o;
        return super.equals(other) && this.delimiter == other.delimiter && Objects.equals(this.escapeChar, other.escapeChar) && this.deleteHeadDelimiter == other.deleteHeadDelimiter && Objects.equals(this.deleteEscapeCharWhileDes, other.deleteEscapeCharWhileDes) && Objects.equals(this.autoAppendEscapeCharAfterDes, other.autoAppendEscapeCharAfterDes);
    }
}

