/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.inlong.sort.protocol.StreamInfo;

public class GroupInfo
implements Serializable {
    private static final long serialVersionUID = 6034630524669634079L;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="streams")
    private List<StreamInfo> streams;
    private Map<String, String> properties;

    @JsonCreator
    public GroupInfo(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="streams") List<StreamInfo> streams) {
        this.groupId = Preconditions.checkNotNull(groupId, "groupId is null");
        this.streams = Preconditions.checkNotNull(streams, "streams is null");
        this.properties = new HashMap<String, String>();
        Preconditions.checkState(!streams.isEmpty(), "streams is empty");
    }

    public GroupInfo(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="streams") List<StreamInfo> streams, Map<String, String> properties) {
        this.groupId = Preconditions.checkNotNull(groupId, "groupId is null");
        this.streams = Preconditions.checkNotNull(streams, "streams is null");
        this.properties = properties;
        Preconditions.checkState(!streams.isEmpty(), "streams is empty");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<StreamInfo> getStreams() {
        return this.streams;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setStreams(List<StreamInfo> streams) {
        this.streams = streams;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupInfo)) {
            return false;
        }
        GroupInfo other = (GroupInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<StreamInfo> this$streams = this.getStreams();
        List<StreamInfo> other$streams = other.getStreams();
        if (this$streams == null ? other$streams != null : !((Object)this$streams).equals(other$streams)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<StreamInfo> $streams = this.getStreams();
        result = result * 59 + ($streams == null ? 43 : ((Object)$streams).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "GroupInfo(groupId=" + this.getGroupId() + ", streams=" + this.getStreams() + ", properties=" + this.getProperties() + ")";
    }
}

