/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.function;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundTimestampFunction
extends ScalarFunction {
    private static final long serialVersionUID = 1L;
    public static final Logger LOG = LoggerFactory.getLogger(RoundTimestampFunction.class);
    public static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    private transient Map<String, DateTimeFormatter> formatters;

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        this.formatters = new HashMap<String, DateTimeFormatter>();
    }

    public String eval(Long timestamp, Long roundTime, String format) {
        try {
            LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp - timestamp % roundTime), DEFAULT_ZONE);
            DateTimeFormatter formatter = this.formatters.get(format);
            if (formatter == null) {
                formatter = DateTimeFormatter.ofPattern(format);
                this.formatters.put(format, formatter);
            }
            return dateTime.format(formatter);
        }
        catch (Exception e) {
            LOG.error("get formatted timestamp error, timestamp: {}, roundTime: {},format: {}", timestamp, roundTime, format, e);
            return null;
        }
    }
}

