/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.formats.json.canal.CanalJsonDeserializationSchema;

public class CanalJsonDecodingFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private List<String> metadataKeys;
    @Nullable
    private final String database;
    @Nullable
    private final String table;
    private final boolean ignoreParseErrors;
    private final TimestampFormat timestampFormat;

    public CanalJsonDecodingFormat(String database, String table, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this.database = database;
        this.table = table;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormat = timestampFormat;
        this.metadataKeys = Collections.emptyList();
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
        List<ReadableMetadata> readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        List metadataFields = readableMetadata.stream().map(m4 -> DataTypes.FIELD((String)m4.key, (DataType)m4.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        return CanalJsonDeserializationSchema.builder(physicalDataType, readableMetadata, (TypeInformation<RowData>)producedTypeInfo).setDatabase(this.database).setTable(this.table).setIgnoreParseErrors(this.ignoreParseErrors).setTimestampFormat(this.timestampFormat).build();
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(ReadableMetadata.values()).forEachOrdered(m4 -> metadataMap.put(m4.key, m4.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public static enum ReadableMetadata {
        DATABASE("database", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"database", (DataType)DataTypes.STRING()), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }

            @Override
            public Object convert(Object in) {
                return StringData.fromString((String)in.toString());
            }
        }),
        TABLE("table", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"table", (DataType)DataTypes.STRING()), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }

            @Override
            public Object convert(Object in) {
                return StringData.fromString((String)in.toString());
            }
        }),
        SQL_TYPE("sql-type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable())).nullable(), DataTypes.FIELD((String)"sqlType", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable()))), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getMap(pos);
            }

            @Override
            public Object convert(Object in) {
                return new GenericMapData((Map)in);
            }
        }),
        PK_NAMES("pk-names", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).nullable(), DataTypes.FIELD((String)"pkNames", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getArray(pos);
            }

            @Override
            public Object convert(Object in) {
                return new GenericArrayData((Object[])in);
            }
        }),
        INGESTION_TIMESTAMP("ingestion-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), DataTypes.FIELD((String)"ts", (DataType)DataTypes.BIGINT()), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return TimestampData.fromEpochMillis((long)row.getLong(pos));
            }

            @Override
            public Object convert(Object in) {
                return in;
            }
        }),
        EVENT_TIMESTAMP("event-timestamp", (DataType)DataTypes.BIGINT().nullable(), DataTypes.FIELD((String)"es", (DataType)DataTypes.BIGINT()), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getLong(pos);
            }

            @Override
            public Object convert(Object in) {
                return in;
            }
        }),
        IS_DDL("is-ddl", (DataType)DataTypes.BOOLEAN().nullable(), DataTypes.FIELD((String)"isDdl", (DataType)DataTypes.BOOLEAN()), new CanalJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return row.getBoolean(pos);
            }

            @Override
            public Object convert(Object in) {
                return in;
            }
        });

        final String key;
        final DataType dataType;
        final DataTypes.Field requiredJsonField;
        final CanalJsonDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DataTypes.Field requiredJsonField, CanalJsonDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.requiredJsonField = requiredJsonField;
            this.converter = converter;
        }

        public String getKey() {
            return this.key;
        }
    }
}

