/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit;

import org.apache.inlong.audit.entity.AuditType;
import org.apache.inlong.audit.entity.CdcType;
import org.apache.inlong.audit.entity.FlowType;
import org.apache.inlong.audit.exceptions.AuditTypeNotExistException;
import org.apache.inlong.audit.util.AuditManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CdcIdEnum {
    MYSQL_INSERT(1, CdcType.INSERT, AuditType.MYSQL, "Insert Audit Metrics for MySQL"),
    MYSQL_DELETE(2, CdcType.DELETE, AuditType.MYSQL, "Delete Audit Metrics for MySQL"),
    MYSQL_UPDATE_BEFORE(3, CdcType.UPDATE_BEFORE, AuditType.MYSQL, "Update before Audit Metrics for MySQL"),
    MYSQL_UPDATE_AFTER(4, CdcType.UPDATE_AFTER, AuditType.MYSQL, "Update after Audit Metrics for MySQL"),
    TDSQL_INSERT(101, CdcType.INSERT, AuditType.TDSQL_MYSQL, "Insert Audit Metrics for TDSQL"),
    TDSQL_DELETE(102, CdcType.DELETE, AuditType.TDSQL_MYSQL, "Delete Audit Metrics for TDSQL"),
    TDSQL_UPDATE_BEFORE(103, CdcType.UPDATE_BEFORE, AuditType.TDSQL_MYSQL, "Update before Audit Metrics for TDSQL"),
    TDSQL_UPDATE_AFTER(104, CdcType.UPDATE_AFTER, AuditType.TDSQL_MYSQL, "Update after Audit Metrics for TDSQL"),
    BINLOG_INSERT(201, CdcType.INSERT, AuditType.BINLOG, "Insert Audit Metrics for MYSQL BINLOG"),
    BINLOG_DELETE(202, CdcType.DELETE, AuditType.BINLOG, "Delete Audit Metrics for MYSQL BINLOG"),
    BINLOG_UPDATE_BEFORE(203, CdcType.UPDATE_BEFORE, AuditType.BINLOG, "Update before Audit Metrics for MYSQL BINLOG"),
    BINLOG_UPDATE_AFTER(204, CdcType.UPDATE_AFTER, AuditType.BINLOG, "Update after Audit Metrics for MYSQL BINLOG");

    private static final Logger LOGGER;
    private final int auditId;
    private final CdcType cdcType;
    private final AuditType auditType;
    private final String description;

    private CdcIdEnum(int auditId, CdcType cdcType, AuditType auditType, String description) {
        this.auditId = auditId;
        this.cdcType = cdcType;
        this.auditType = auditType;
        this.description = description;
    }

    public static CdcIdEnum getCdcIdEnum(String auditType, CdcType cdcType) {
        if (auditType == null || cdcType == null) {
            throw new IllegalArgumentException("Audit type and CDC type must not be null");
        }
        for (CdcIdEnum cdcIdEnum : CdcIdEnum.values()) {
            if (cdcIdEnum.getCdcType() != cdcType || !auditType.equalsIgnoreCase(cdcIdEnum.getAuditType().value())) continue;
            return cdcIdEnum;
        }
        String errorMsg = String.format("Audit type %s does not exist for cdc type %s", new Object[]{auditType, cdcType});
        LOGGER.error(errorMsg);
        throw new AuditTypeNotExistException(errorMsg);
    }

    public static int getCdcId(String auditType, FlowType flowType, CdcType cdcType) {
        CdcIdEnum cdcIdEnum = CdcIdEnum.getCdcIdEnum(auditType, cdcType);
        return cdcIdEnum.getValue(flowType);
    }

    public int getValue(FlowType flowType) {
        if (flowType == null) {
            LOGGER.error("Invalid flow type: must not be null");
            return -1;
        }
        try {
            return this.auditId + (flowType == FlowType.INPUT ? AuditManagerUtils.getStartAuditIdForCdcInput() : AuditManagerUtils.getStartAuditIdForCdcOutput());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get audit ID for flow type: {}", (Object)flowType, (Object)e);
            return -1;
        }
    }

    public String getEnglishDescription(FlowType flowType) {
        return String.join((CharSequence)"", this.auditType.value(), flowType.getNameInEnglish(), this.cdcType.getNameInEnglish());
    }

    public String getChineseDescription(FlowType flowType) {
        return String.join((CharSequence)"", this.auditType.value(), flowType.getNameInChinese(), this.cdcType.getNameInChinese());
    }

    public CdcType getCdcType() {
        return this.cdcType;
    }

    public AuditType getAuditType() {
        return this.auditType;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        LOGGER = LoggerFactory.getLogger(CdcIdEnum.class);
    }
}

