/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.AuditIdEnum;
import org.apache.inlong.audit.entity.AuditComponent;
import org.apache.inlong.audit.entity.AuditInformation;
import org.apache.inlong.audit.entity.AuditMetric;
import org.apache.inlong.audit.entity.CdcType;
import org.apache.inlong.audit.entity.FlowType;
import org.apache.inlong.audit.loader.SocketAddressListLoader;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.send.ProxyManager;
import org.apache.inlong.audit.send.SenderManager;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.audit.util.AuditDimensions;
import org.apache.inlong.audit.util.AuditManagerUtils;
import org.apache.inlong.audit.util.AuditValues;
import org.apache.inlong.audit.util.Config;
import org.apache.inlong.audit.util.RequestIdUtils;
import org.apache.inlong.audit.util.StatInfo;
import org.apache.inlong.audit.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditReporterImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditReporterImpl.class);
    private static final String FIELD_SEPARATORS = ":";
    private static final long DEFAULT_AUDIT_VERSION = -1L;
    private static final int BATCH_NUM = 100;
    private static final int PERIOD = 60000;
    public static final long DEFAULT_ISOLATE_KEY = 0L;
    private final ReentrantLock GLOBAL_LOCK = new ReentrantLock();
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, StatInfo>> preStatMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, StatInfo>> summaryStatMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, StatInfo>> expiredStatMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashSet<String>> expiredKeyList = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Long> flushTime = new ConcurrentHashMap();
    private final Config config = new Config();
    private final ScheduledExecutorService timerExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("inlong-audit-flush"));
    private int packageId = 1;
    private int dataId = 0;
    private volatile boolean initialized = false;
    private SenderManager manager;
    private AtomicInteger flushStat = new AtomicInteger(0);
    private AuditConfig auditConfig = null;
    private SocketAddressListLoader loader = null;
    private int flushStatThreshold = 100;
    private boolean autoFlush = true;
    private boolean enableDebug = false;
    private AuditMetric auditMetric = new AuditMetric();

    public void setFlushStatThreshold(int flushStatThreshold) {
        this.flushStatThreshold = flushStatThreshold;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.config.init();
        this.timerExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    AuditReporterImpl.this.loadIpPortList();
                    AuditReporterImpl.this.checkFlushTime();
                    if (AuditReporterImpl.this.autoFlush) {
                        AuditReporterImpl.this.flush(0L);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Audit run has exception!", e);
                }
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
        if (this.auditConfig == null) {
            this.auditConfig = new AuditConfig();
        }
        this.manager = new SenderManager(this.auditConfig);
    }

    private void loadIpPortList() {
        if (this.loader == null) {
            return;
        }
        try {
            List<String> ipPortList = this.loader.loadSocketAddressList();
            if (ipPortList != null && ipPortList.size() > 0) {
                HashSet<String> ipPortSet = new HashSet<String>();
                ipPortSet.addAll(ipPortList);
                this.setAuditProxy(ipPortSet);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public void setLoader(SocketAddressListLoader loader) {
        this.loader = loader;
    }

    public void setLoaderClass(String loaderClassName) {
        if (StringUtils.isEmpty(loaderClassName)) {
            return;
        }
        try {
            Class<?> loaderClass = ClassUtils.getClass(loaderClassName);
            Object loaderObject = loaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (loaderObject instanceof SocketAddressListLoader) {
                SocketAddressListLoader loader;
                this.loader = loader = (SocketAddressListLoader)loaderObject;
                LOGGER.info("Audit list loader class:{}", (Object)loaderClassName);
            }
        }
        catch (Throwable t2) {
            LOGGER.error("Fail to init list loader class:{},error:{}", loaderClassName, t2.getMessage(), t2);
        }
    }

    public void setAuditProxy(HashSet<String> ipPortList) {
        this.checkInitStatus();
        ProxyManager.getInstance().setAuditProxy(ipPortList);
    }

    public void setLocalIP(String localIP) {
        this.config.setLocalIP(localIP);
    }

    public void setAuditProxy(AuditComponent component, String managerHost, String secretId, String secretKey) {
        this.checkInitStatus();
        ProxyManager.getInstance().setManagerConfig(component, managerHost, secretId, secretKey);
    }

    private synchronized void checkInitStatus() {
        if (this.initialized) {
            return;
        }
        this.init();
        this.initialized = true;
    }

    public void setAuditConfig(AuditConfig config) {
        this.auditConfig = config;
        this.manager.setAuditConfig(config);
    }

    public void add(int auditID, String inlongGroupID, String inlongStreamID, long logTime, long count, long size) {
        this.add(auditID, "-1", inlongGroupID, inlongStreamID, logTime, count, size, -1L);
    }

    public void add(long isolateKey, int auditID, String auditTag, String inlongGroupID, String inlongStreamID, long logTime, long count, long size, long auditVersion) {
        long delayTime = System.currentTimeMillis() - logTime;
        this.add(isolateKey, auditID, auditTag, inlongGroupID, inlongStreamID, logTime, count, size, delayTime, auditVersion);
    }

    public void add(int auditID, String auditTag, String inlongGroupID, String inlongStreamID, long logTime, long count, long size, long auditVersion) {
        long delayTime = System.currentTimeMillis() - logTime;
        this.add(0L, auditID, auditTag, inlongGroupID, inlongStreamID, logTime, count, size, delayTime * count, auditVersion);
    }

    public void add(int auditID, String inlongGroupID, String inlongStreamID, long logTime, long count, long size, long delayTime) {
        this.add(0L, auditID, "-1", inlongGroupID, inlongStreamID, logTime, count, size, delayTime, -1L);
    }

    public void add(long isolateKey, int auditID, String auditTag, String inlongGroupID, String inlongStreamID, long logTime, long count, long size, long delayTime, long auditVersion) {
        StringJoiner keyJoiner = new StringJoiner(FIELD_SEPARATORS);
        keyJoiner.add(String.valueOf(logTime / 60000L));
        keyJoiner.add(inlongGroupID);
        keyJoiner.add(inlongStreamID);
        keyJoiner.add(String.valueOf(auditID));
        keyJoiner.add(auditTag);
        keyJoiner.add(String.valueOf(auditVersion));
        this.addByKey(isolateKey, keyJoiner.toString(), count, size, delayTime);
    }

    public void add(AuditDimensions dimensions, AuditValues values) {
        StringJoiner keyJoiner = new StringJoiner(FIELD_SEPARATORS);
        keyJoiner.add(String.valueOf(dimensions.getLogTime() / 60000L));
        keyJoiner.add(dimensions.getInlongGroupID());
        keyJoiner.add(dimensions.getInlongStreamID());
        keyJoiner.add(String.valueOf(dimensions.getAuditID()));
        keyJoiner.add(dimensions.getAuditTag());
        keyJoiner.add(String.valueOf(dimensions.getAuditVersion()));
        this.addByKey(dimensions.getIsolateKey(), keyJoiner.toString(), values.getCount(), values.getSize(), values.getDelayTime());
    }

    private void addByKey(long isolateKey, String statKey, long count, long size, long delayTime) {
        ConcurrentHashMap<String, StatInfo> statMap;
        if (null == this.preStatMap.get(isolateKey)) {
            this.preStatMap.putIfAbsent(isolateKey, new ConcurrentHashMap());
        }
        if (null == (statMap = this.preStatMap.get(isolateKey)).get(statKey)) {
            statMap.putIfAbsent(statKey, new StatInfo(0L, 0L, 0L));
        }
        StatInfo stat = statMap.get(statKey);
        stat.count.addAndGet(count);
        stat.size.addAndGet(size);
        stat.delay.addAndGet(delayTime);
    }

    public synchronized void asyncFlush(long isolateKey) {
        LOGGER.info("Async flush audit by isolate key: {} ", (Object)isolateKey);
        Runnable task = () -> {
            try {
                this.flush(isolateKey);
            }
            catch (Exception e) {
                LOGGER.error("Async flush audit by isolate key: {}, has exception: ", (Object)isolateKey, (Object)e);
            }
        };
        this.timerExecutor.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    public synchronized void flush() {
        this.flush(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(long isolateKey) {
        if (this.flushTime.putIfAbsent(isolateKey, System.currentTimeMillis()) != null || this.flushStat.addAndGet(1) > this.flushStatThreshold) {
            LOGGER.info("Skip audit flush isolate key: {}, last flush time: {}, count: {}", isolateKey, this.flushTime.get(isolateKey), this.flushStat.get());
            return;
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("Audit flush isolate key: {} ", (Object)isolateKey);
        try {
            this.manager.checkFailedData();
            this.resetStat();
            this.summaryExpiredStatMap(isolateKey);
            Iterator<Map.Entry<Long, ConcurrentHashMap<String, StatInfo>>> iterator = this.preStatMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ConcurrentHashMap<String, StatInfo>> entry = iterator.next();
                if (entry.getValue().isEmpty()) {
                    LOGGER.info("Remove the key of pre stat map: {},isolate key: {} ", (Object)entry.getKey(), (Object)isolateKey);
                    iterator.remove();
                    continue;
                }
                if (entry.getKey() > isolateKey) continue;
                this.summaryPreStatMap(entry.getKey(), entry.getValue());
                this.send(entry.getKey());
            }
            this.clearExpiredKey(isolateKey);
        }
        catch (Exception exception) {
            LOGGER.error("Flush audit has exception!", exception);
        }
        finally {
            this.manager.closeSocket();
        }
        LOGGER.info("Success report {} package, Failed report {} package, total {} message, memory size {}, cost: {} ms", this.auditMetric.getSuccessPack(), this.auditMetric.getFailedPack(), this.auditMetric.getTotalMsg(), this.auditMetric.getMemorySize(), System.currentTimeMillis() - startTime);
        this.auditMetric.reset();
    }

    private void sendByBaseCommand(AuditApi.AuditRequest auditRequest) {
        AuditApi.BaseCommand.Builder baseCommand = AuditApi.BaseCommand.newBuilder();
        baseCommand.setType(AuditApi.BaseCommand.Type.AUDIT_REQUEST).setAuditRequest(auditRequest).build();
        if (this.manager.send(baseCommand.build(), auditRequest)) {
            this.auditMetric.addSuccessPack(1L);
        } else {
            this.auditMetric.addFailedPack(1L);
        }
    }

    private void sumThreadGroup(long isolateKey, String key, StatInfo statInfo) {
        long count = statInfo.count.getAndSet(0L);
        if (0L == count) {
            return;
        }
        ConcurrentHashMap sumMap = this.summaryStatMap.computeIfAbsent(isolateKey, k -> new ConcurrentHashMap());
        StatInfo stat = sumMap.computeIfAbsent(key, k -> new StatInfo(0L, 0L, 0L));
        stat.count.addAndGet(count);
        stat.size.addAndGet(statInfo.size.getAndSet(0L));
        stat.delay.addAndGet(statInfo.delay.getAndSet(0L));
    }

    private void resetStat() {
        this.dataId = 0;
        this.packageId = 1;
    }

    private void summaryExpiredStatMap(long isolateKey) {
        Iterator<Map.Entry<Long, ConcurrentHashMap<String, StatInfo>>> iterator = this.expiredStatMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, ConcurrentHashMap<String, StatInfo>> entry = iterator.next();
            if (entry.getValue().isEmpty()) {
                LOGGER.info("Remove the key of expired stat map: {},isolate key: {} ", (Object)entry.getKey(), (Object)isolateKey);
                iterator.remove();
                continue;
            }
            if (entry.getKey() > isolateKey) continue;
            for (Map.Entry<String, StatInfo> statInfo : entry.getValue().entrySet()) {
                this.sumThreadGroup(isolateKey, statInfo.getKey(), statInfo.getValue());
            }
            entry.getValue().clear();
        }
    }

    private void summaryPreStatMap(long isolateKey, ConcurrentHashMap<String, StatInfo> statInfo) {
        Set expiredKeys = this.expiredKeyList.computeIfAbsent(isolateKey, k -> new HashSet());
        for (Map.Entry<String, StatInfo> entry : statInfo.entrySet()) {
            String key = entry.getKey();
            StatInfo value = entry.getValue();
            if (value.count.get() == 0L) {
                expiredKeys.add(key);
                continue;
            }
            this.sumThreadGroup(isolateKey, key, value);
        }
    }

    private void clearExpiredKey(long isolateKey) {
        Iterator<Map.Entry<Long, HashSet<String>>> iterator = this.expiredKeyList.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, HashSet<String>> entry = iterator.next();
            if (entry.getValue().isEmpty()) {
                LOGGER.info("Remove the key of expired key list: {}, isolate key: {}", (Object)entry.getKey(), (Object)isolateKey);
                iterator.remove();
                continue;
            }
            if (entry.getKey() > isolateKey) continue;
            ConcurrentHashMap<String, StatInfo> preStatInfo = this.preStatMap.get(entry.getKey());
            if (null == preStatInfo) {
                iterator.remove();
                continue;
            }
            ConcurrentHashMap deleteMap = this.expiredStatMap.computeIfAbsent(entry.getKey(), k -> new ConcurrentHashMap());
            for (String key : entry.getValue()) {
                StatInfo value = preStatInfo.remove(key);
                deleteMap.put(key, value);
            }
            entry.getValue().clear();
        }
    }

    private void send(long isolateKey) {
        if (null == this.summaryStatMap.get(isolateKey)) {
            return;
        }
        if (this.summaryStatMap.get(isolateKey).isEmpty()) {
            this.summaryStatMap.remove(isolateKey);
            return;
        }
        long sdkTime = Calendar.getInstance().getTimeInMillis();
        AuditApi.AuditMessageHeader msgHeader = AuditApi.AuditMessageHeader.newBuilder().setIp(this.config.getLocalIP()).setDockerId(this.config.getDockerId()).setThreadId(String.valueOf(Thread.currentThread().getId())).setSdkTs(sdkTime).setPacketId(this.packageId).build();
        AuditApi.AuditRequest.Builder requestBuild = AuditApi.AuditRequest.newBuilder();
        requestBuild.setMsgHeader(msgHeader);
        for (Map.Entry<String, StatInfo> entry : this.summaryStatMap.get(isolateKey).entrySet()) {
            long auditVersion;
            long logTime;
            String[] keyArray = entry.getKey().split(FIELD_SEPARATORS);
            if (keyArray.length < 6) {
                LOGGER.error("Number of keys {} <6", (Object)keyArray.length);
                continue;
            }
            try {
                logTime = Long.parseLong(keyArray[0]) * 60000L;
                auditVersion = Long.parseLong(keyArray[5]);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error("Failed to parse long from string", numberFormatException);
                continue;
            }
            String inlongGroupID = keyArray[1];
            String inlongStreamID = keyArray[2];
            String auditID = keyArray[3];
            String auditTag = keyArray[4];
            StatInfo value = entry.getValue();
            AuditApi.AuditMessageBody msgBody = AuditApi.AuditMessageBody.newBuilder().setLogTs(logTime).setInlongGroupId(inlongGroupID).setInlongStreamId(inlongStreamID).setAuditId(auditID).setAuditTag(auditTag).setCount(value.count.get()).setSize(value.size.get()).setDelay(value.delay.get()).setAuditVersion(auditVersion).build();
            requestBuild.addMsgBody(msgBody);
            this.auditMetric.addMemorySize(msgBody.toByteArray().length);
            if (this.dataId++ < 100) continue;
            this.dataId = 0;
            ++this.packageId;
            this.sendData(requestBuild, isolateKey);
        }
        if (requestBuild.getMsgBodyCount() > 0) {
            this.sendData(requestBuild, isolateKey);
        }
        this.summaryStatMap.get(isolateKey).clear();
    }

    private void sendData(AuditApi.AuditRequest.Builder requestBuild, long isolateKey) {
        if (this.enableDebug) {
            LOGGER.info("Send audit data by isolate key: {}, data: {}", (Object)isolateKey, (Object)requestBuild);
        }
        requestBuild.setRequestId(RequestIdUtils.nextRequestId());
        this.sendByBaseCommand(requestBuild.build());
        this.auditMetric.addTotalMsg(requestBuild.getMsgBodyCount());
        requestBuild.clearMsgBody();
    }

    private void checkFlushTime() {
        this.flushStat.set(0);
        long currentTime = Calendar.getInstance().getTimeInMillis();
        this.flushTime.forEach((key, value) -> {
            if (currentTime - value > 60000L) {
                this.flushTime.remove(key);
                LOGGER.info("Remove audit flush limitation. isolate key: {}, flush time: {}", key, value);
            }
        });
    }

    public int buildAuditId(AuditIdEnum baseAuditId, boolean success, boolean isRealtime, boolean discard, boolean retry) {
        return AuditManagerUtils.buildAuditId(baseAuditId, success, isRealtime, discard, retry);
    }

    public int buildSuccessfulAuditId(AuditIdEnum baseAuditId) {
        return this.buildAuditId(baseAuditId, true, true, false, false);
    }

    public int buildSuccessfulAuditId(AuditIdEnum baseAuditId, boolean isRealtime) {
        return this.buildAuditId(baseAuditId, true, isRealtime, false, false);
    }

    public int buildFailedAuditId(AuditIdEnum baseAuditId) {
        return this.buildAuditId(baseAuditId, false, true, false, false);
    }

    public int buildFailedAuditId(AuditIdEnum baseAuditId, boolean isRealtime) {
        return this.buildAuditId(baseAuditId, false, isRealtime, false, false);
    }

    public int buildDiscardAuditId(AuditIdEnum baseAuditId) {
        return this.buildAuditId(baseAuditId, true, true, true, false);
    }

    public int buildDiscardAuditId(AuditIdEnum baseAuditId, boolean isRealtime) {
        return this.buildAuditId(baseAuditId, true, isRealtime, true, false);
    }

    public int buildRetryAuditId(AuditIdEnum baseAuditId) {
        return this.buildAuditId(baseAuditId, true, true, false, true);
    }

    public int buildRetryAuditId(AuditIdEnum baseAuditId, boolean isRealtime) {
        return this.buildAuditId(baseAuditId, true, isRealtime, false, true);
    }

    public AuditInformation buildAuditInformation(String auditType, FlowType dataFlow, boolean success, boolean isRealtime, boolean discard, boolean retry) {
        return AuditManagerUtils.buildAuditInformation(auditType, dataFlow, success, isRealtime, discard, retry);
    }

    public List<AuditInformation> getAllAuditInformation() {
        return AuditManagerUtils.getAllAuditInformation();
    }

    public List<AuditInformation> getAllMetricInformation() {
        return AuditManagerUtils.getAllMetricInformation();
    }

    public List<AuditInformation> getAllAuditInformation(String auditType) {
        return AuditManagerUtils.getAllAuditInformation(auditType);
    }

    public int getStartAuditIdForMetric() {
        return AuditManagerUtils.getStartAuditIdForMetric();
    }

    public void setManagerTimeout(int timeoutMs) {
        ProxyManager.getInstance().setManagerTimeout(timeoutMs);
    }

    public void setAutoUpdateAuditProxy() {
        ProxyManager.getInstance().setAutoUpdateAuditProxy();
    }

    public void setUpdateInterval(int updateInterval) {
        ProxyManager.getInstance().setUpdateInterval(updateInterval);
    }

    public void setMaxGlobalAuditMemory(long maxGlobalAuditMemory) {
        SenderManager.setMaxGlobalAuditMemory(maxGlobalAuditMemory);
    }

    public int getCdcId(String auditType, FlowType flowType, CdcType cdcType) {
        return AuditManagerUtils.getCdcId(auditType, flowType, cdcType);
    }

    public List<AuditInformation> getAllCdcIdInformation() {
        return AuditManagerUtils.getAllCdcIdInformation();
    }

    public List<AuditInformation> getAllCdcIdInformation(String auditType) {
        return AuditManagerUtils.getAllCdcIdInformation(auditType);
    }

    public List<AuditInformation> getAllCdcIdInformation(String auditType, FlowType flowType) {
        return AuditManagerUtils.getAllCdcIdInformation(auditType, flowType);
    }

    public AuditInformation getCdcIdInformation(String auditType, FlowType flowType, CdcType cdcType) {
        return AuditManagerUtils.getCdcIdInformation(auditType, flowType, cdcType);
    }

    public void shutdown() {
        ProxyManager.getInstance().shutdown();
        this.timerExecutor.shutdown();
    }
}

