/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.ogg;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.ogg.OggJsonDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.types.RowKind;

public class OggJsonDecodingFormat
implements DecodingFormat<DeserializationSchema<RowData>> {
    private List<String> metadataKeys;
    private final boolean ignoreParseErrors;
    private final TimestampFormat timestampFormat;

    public OggJsonDecodingFormat(boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormat = timestampFormat;
        this.metadataKeys = Collections.emptyList();
    }

    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType) {
        List<ReadableMetadata> readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toList());
        List metadataFields = readableMetadata.stream().map(m4 -> DataTypes.FIELD((String)m4.key, (DataType)m4.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields((DataType)physicalDataType, metadataFields);
        TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
        return new OggJsonDeserializationSchema(physicalDataType, readableMetadata, (TypeInformation<RowData>)producedTypeInfo, this.ignoreParseErrors, this.timestampFormat);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(ReadableMetadata.values()).forEachOrdered(m4 -> metadataMap.put(m4.key, m4.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    static enum ReadableMetadata {
        TABLE("table", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD((String)"table", (DataType)DataTypes.STRING()), new OggJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }
        }),
        PRIMARY_KEYS("primary-keys", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING()).nullable(), DataTypes.FIELD((String)"primary_keys", (DataType)DataTypes.ARRAY((DataType)DataTypes.STRING())), new OggJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getArray(pos);
            }
        }),
        INGESTION_TIMESTAMP("ingestion-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6).nullable(), DataTypes.FIELD((String)"current_ts", (DataType)DataTypes.STRING()), new OggJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return DateTimeUtils.parseTimestampData((String)row.getString(pos).toString(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
            }
        }),
        EVENT_TIMESTAMP("event-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)6).nullable(), DataTypes.FIELD((String)"op_ts", (DataType)DataTypes.STRING()), new OggJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return DateTimeUtils.parseTimestampData((String)row.getString(pos).toString());
            }
        });

        final String key;
        final DataType dataType;
        final DataTypes.Field requiredJsonField;
        final OggJsonDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DataTypes.Field requiredJsonField, OggJsonDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.requiredJsonField = requiredJsonField;
            this.converter = converter;
        }
    }
}

