/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"unix_timestamp"}, parameter="([String dateStr [, String format]])", descriptions={"- Return current Unix timestamp in seconds if no parameter is specified;", "- Return the result of converting the date and time string 'dateStr' to the format 'format' (by default: yyyy-MM-dd HH:mm:ss if not specified) to Unix timestamp (in seconds) if there is a parameter specified"}, examples={"unix_timestamp('1970/01/01 08:00:44', 'yyyy/MM/dd HH:mm:ss') = \"1970/01/01 08:00:44\""})
public class UnixTimestampFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser formatParser;
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public UnixTimestampFunction(Function expr) {
        if (expr.getParameters() == null) {
            return;
        }
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() == 2) {
            this.formatParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.stringParser == null) {
            return Instant.now().getEpochSecond();
        }
        String dateString = OperatorTools.parseString(this.stringParser.parse(sourceData, rowIndex, context));
        String formatPattern = this.formatParser != null ? OperatorTools.parseString(this.formatParser.parse(sourceData, rowIndex, context)) : DEFAULT_FORMAT;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatPattern);
        LocalDateTime dateTime = LocalDateTime.parse(dateString, formatter);
        return dateTime.atZone(ZoneId.systemDefault()).toEpochSecond();
    }
}

