/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"replace"}, parameter="(String s, String s1, String s2)", descriptions={"- Return \"\" if any parameter is null;", "- Return the result of replacing string 's1' with string 's2' in string 's'."}, examples={"replace('Hello World', '', 'J') = \"JHJeJlJlJoJ JWJoJrJlJdJ\""})
public class ReplaceFunction
implements ValueParser {
    private ValueParser stringParser;
    private ValueParser targetParser;
    private ValueParser replacementParser;

    public ReplaceFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.targetParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.replacementParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object strObj = this.stringParser.parse(sourceData, rowIndex, context);
        Object targetObj = this.targetParser.parse(sourceData, rowIndex, context);
        Object replacementObj = this.replacementParser.parse(sourceData, rowIndex, context);
        if (strObj == null || targetObj == null || replacementObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(strObj);
        String target = OperatorTools.parseString(targetObj);
        String replacement = OperatorTools.parseString(replacementObj);
        return str.replace(target, replacement);
    }
}

