/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_max"}, parameter="(Array array)", descriptions={"- Return \"\" if any parameter is null;", "- Return the maximum value from the 'array'."}, examples={"array_max(array(4,3,56)) = 56"})
public class ArrayMaxFunction
implements ValueParser {
    private final ValueParser arrayParser;

    public ArrayMaxFunction(Function expr) {
        this.arrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            int max = Integer.parseInt(String.valueOf(array.get(0)));
            for (Object element : array) {
                int elementInt = Integer.parseInt((String)element);
                if (elementInt - max <= 0) continue;
                max = elementInt;
            }
            return max;
        }
        return null;
    }
}

