/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_except"}, parameter="(Array array1, Array array2)", descriptions={"- Return \"\" if any parameter is null;", "- Return an ARRAY that contains the elements from 'array1' that are not in 'array2', without duplicates;", "- Return an empty ARRAY if no elements remain after excluding the elements in 'array2' from 'array1'."}, examples={"array_except(array('he',7,'xxd'),array('he')) = [7, xxd]", "array_except(array('he',7,'xxd'),array('cloud')) = [he, 7, xxd]"})
public class ArrayExceptFunction
implements ValueParser {
    private final ValueParser leftArrayParser;
    private final ValueParser rightArrayParser;

    public ArrayExceptFunction(Function expr) {
        this.leftArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        this.rightArrayParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftArrayObj = this.leftArrayParser.parse(sourceData, rowIndex, context);
        Object rightArrayObj = this.rightArrayParser.parse(sourceData, rowIndex, context);
        if (leftArrayObj == null || rightArrayObj == null) {
            return null;
        }
        if (leftArrayObj instanceof ArrayList && rightArrayObj instanceof ArrayList) {
            ArrayList leftArray = (ArrayList)leftArrayObj;
            ArrayList rightArray = (ArrayList)rightArrayObj;
            if (leftArray.isEmpty() || rightArray.isEmpty()) {
                return null;
            }
            LinkedHashSet res = new LinkedHashSet();
            for (Object value : leftArray) {
                if (rightArray.contains(value)) continue;
                res.add(value);
            }
            return new ArrayList(res);
        }
        return null;
    }
}

