/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.inlong.sdk.transform.pojo.CsvSinkInfo;
import org.apache.inlong.sdk.transform.pojo.KvSinkInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CsvSinkInfo.class, name="csv"), @JsonSubTypes.Type(value=KvSinkInfo.class, name="kv")})
public abstract class SinkInfo {
    public static final String CSV = "csv";
    public static final String KV = "kv";
    public static final String ES_MAP = "es_map";
    public static final String PARQUET = "parquet";
    public static final String PB = "pb";
    public static final String ROWDATA = "rowdata";
    @JsonIgnore
    private String type;
    @JsonProperty(value="charset")
    private String charset;

    public SinkInfo(String type, @JsonProperty(value="charset") String charset) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.charset = Optional.ofNullable(charset).orElse("UTF-8");
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="charset")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected SinkInfo(SinkInfoBuilder<?, ?> b) {
        this.type = ((SinkInfoBuilder)b).type;
        this.charset = ((SinkInfoBuilder)b).charset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkInfo)) {
            return false;
        }
        SinkInfo other = (SinkInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }

    public String toString() {
        return "SinkInfo(type=" + this.getType() + ", charset=" + this.getCharset() + ")";
    }

    public static abstract class SinkInfoBuilder<C extends SinkInfo, B extends SinkInfoBuilder<C, B>> {
        private String type;
        private String charset;

        protected abstract B self();

        public abstract C build();

        @JsonIgnore
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @JsonProperty(value="charset")
        public B charset(String charset) {
            this.charset = charset;
            return this.self();
        }

        public String toString() {
            return "SinkInfo.SinkInfoBuilder(type=" + this.type + ", charset=" + this.charset + ")";
        }
    }
}

