/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.pojo.PbSinkInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class PbSinkEncoder
extends SinkEncoder<byte[]> {
    protected PbSinkInfo sinkInfo;
    private Descriptors.Descriptor dynamicDescriptor;
    private final Map<String, Descriptors.FieldDescriptor.Type> fieldTypes;

    public PbSinkEncoder(PbSinkInfo pbSinkInfo) {
        super(pbSinkInfo.getFields());
        this.sinkInfo = pbSinkInfo;
        this.fieldTypes = new HashMap<String, Descriptors.FieldDescriptor.Type>();
        for (FieldInfo field : this.fields) {
            this.fieldTypes.put(field.getName(), Descriptors.FieldDescriptor.Type.STRING);
        }
        this.dynamicDescriptor = this.decodeProtoDescription(pbSinkInfo.getProtoDescription());
    }

    @Override
    public byte[] encode(SinkData sinkData, Context context) {
        try {
            DynamicMessage.Builder dynamicBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.dynamicDescriptor);
            for (String key : sinkData.keyList()) {
                String fieldValue;
                Descriptors.FieldDescriptor fieldDescriptor = this.dynamicDescriptor.findFieldByName(key);
                if (fieldDescriptor == null || (fieldValue = sinkData.getField(key)) == null) continue;
                Object value = this.convertValue(fieldDescriptor, fieldValue);
                dynamicBuilder.setField(fieldDescriptor, value);
            }
            return dynamicBuilder.build().toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Descriptors.Descriptor decodeProtoDescription(String base64ProtoDescription) {
        try {
            byte[] protoBytes = Base64.getDecoder().decode(base64ProtoDescription);
            DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])protoBytes);
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorSet.getFile(0), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            return (Descriptors.Descriptor)fileDescriptor.getMessageTypes().get(0);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode protoDescription", e);
        }
    }

    private Object convertValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        switch (fieldDescriptor.getType()) {
            case STRING: {
                return value.toString();
            }
            case INT32: {
                return Integer.parseInt(value.toString());
            }
            case INT64: {
                return Long.parseLong(value.toString());
            }
            case BOOL: {
                return Boolean.parseBoolean(value.toString());
            }
            case BYTES: {
                return ByteString.copyFromUtf8((String)value.toString());
            }
        }
        throw new IllegalArgumentException("Unsupported field type: " + fieldDescriptor.getType());
    }
}

