/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.util.List;

public class EscapeUtils {
    public static String escapeStringSeparator(String fieldValue, char separator) {
        StringBuilder builder = new StringBuilder();
        EscapeUtils.escapeContent(builder, separator, '\\', fieldValue);
        String formatField = builder.toString();
        return formatField;
    }

    public static String escapeFields(List<String> fields, char separator) {
        if (fields.size() <= 0) {
            return "";
        }
        StringBuilder ss = new StringBuilder();
        for (String field : fields) {
            String fmtField = EscapeUtils.escapeStringSeparator(field, separator);
            ss.append(fmtField).append(separator);
        }
        String result = ss.substring(0, ss.length() - 1);
        return result;
    }

    public static void escapeContent(StringBuilder builder, char separator, char escapeChar, Object field) {
        String strField = "";
        if (field != null) {
            strField = String.valueOf(field);
        }
        int length = strField.length();
        for (int i = 0; i < length; ++i) {
            EscapeUtils.putValueIntoStringBuilder(builder, separator, escapeChar, strField.charAt(i));
        }
    }

    public static void putValueIntoStringBuilder(StringBuilder builder, char separator, char escapeChar, char value) {
        switch (value) {
            case '\u0000': {
                builder.append(escapeChar).append('0');
                break;
            }
            case '\n': {
                builder.append(escapeChar).append('n');
                break;
            }
            case '\r': {
                builder.append(escapeChar).append('r');
                break;
            }
            default: {
                if (value == separator) {
                    builder.append(escapeChar).append(separator);
                    break;
                }
                if (value == escapeChar) {
                    builder.append(escapeChar).append(escapeChar);
                    break;
                }
                builder.append(value);
            }
        }
    }
}

