/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.encode;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.encode.EscapeUtils;
import org.apache.inlong.sdk.transform.encode.SinkData;
import org.apache.inlong.sdk.transform.encode.SinkEncoder;
import org.apache.inlong.sdk.transform.pojo.CsvSinkInfo;
import org.apache.inlong.sdk.transform.pojo.FieldInfo;
import org.apache.inlong.sdk.transform.process.Context;

public class CsvSinkEncoder
extends SinkEncoder<String> {
    protected CsvSinkInfo sinkInfo;
    protected Charset sinkCharset = Charset.defaultCharset();
    private Character delimiter = Character.valueOf('|');
    private Character escapeChar = null;
    private StringBuilder builder = new StringBuilder();

    public CsvSinkEncoder(CsvSinkInfo sinkInfo) {
        super(sinkInfo.getFields());
        this.sinkInfo = sinkInfo;
        if (sinkInfo.getDelimiter() != null) {
            this.delimiter = sinkInfo.getDelimiter();
        }
        if (sinkInfo.getDelimiter() != null) {
            this.escapeChar = sinkInfo.getEscapeChar();
        }
        if (!StringUtils.isBlank((CharSequence)sinkInfo.getCharset())) {
            this.sinkCharset = Charset.forName(sinkInfo.getCharset());
        }
    }

    @Override
    public String encode(SinkData sinkData, Context context) {
        this.builder.delete(0, this.builder.length());
        if (this.fields == null || this.fields.size() == 0) {
            if (this.escapeChar == null) {
                sinkData.keyList().forEach(k -> this.builder.append(sinkData.getField((String)k)).append(this.delimiter));
            } else {
                for (String fieldName : sinkData.keyList()) {
                    String fieldValue = sinkData.getField(fieldName);
                    if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"*")) {
                        this.builder.append(fieldValue);
                    } else {
                        EscapeUtils.escapeContent(this.builder, this.delimiter.charValue(), this.escapeChar.charValue(), fieldValue);
                    }
                    this.builder.append(this.delimiter);
                }
            }
        } else if (this.escapeChar == null) {
            this.fields.forEach(v -> this.builder.append(sinkData.getField(v.getName())).append(this.delimiter));
        } else {
            for (FieldInfo field : this.fields) {
                String fieldName = field.getName();
                String fieldValue = sinkData.getField(fieldName);
                EscapeUtils.escapeContent(this.builder, this.delimiter.charValue(), this.escapeChar.charValue(), fieldValue);
                this.builder.append(this.delimiter);
            }
        }
        return this.builder.substring(0, this.builder.length() - 1);
    }
}

