/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.Yaml;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.SourceDecoder;
import org.apache.inlong.sdk.transform.decode.YamlNode;
import org.apache.inlong.sdk.transform.decode.YamlSourceData;
import org.apache.inlong.sdk.transform.pojo.YamlSourceInfo;
import org.apache.inlong.sdk.transform.process.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlSourceDecoder
extends SourceDecoder<String> {
    private static final Logger log = LoggerFactory.getLogger(YamlSourceDecoder.class);
    protected YamlSourceInfo sourceInfo;
    private Charset srcCharset = Charset.defaultCharset();
    private String rowsNodePath;
    private List<String> childNodes;

    public YamlSourceDecoder(YamlSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        if (!StringUtils.isBlank((CharSequence)sourceInfo.getCharset())) {
            this.srcCharset = Charset.forName(sourceInfo.getCharset());
        }
        this.rowsNodePath = sourceInfo.getRowsNodePath();
        if (!StringUtils.isBlank((CharSequence)this.rowsNodePath)) {
            this.childNodes = new ArrayList<String>();
            String[] nodeStrings = this.rowsNodePath.split("\\.");
            this.childNodes.addAll(Arrays.asList(nodeStrings));
        }
    }

    @Override
    public SourceData decode(byte[] srcBytes, Context context) {
        String srcString = new String(srcBytes, this.srcCharset);
        return this.decode(srcString, context);
    }

    @Override
    public SourceData decode(String srcString, Context context) {
        try {
            Yaml yaml = new Yaml();
            Map yamlData = (Map)yaml.load(srcString);
            HashMap<String, YamlNode> rootMap = new HashMap<String, YamlNode>();
            ArrayList<YamlNode> childList = new ArrayList<YamlNode>();
            for (Map.Entry entry : yamlData.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map<String, YamlNode> childNodes = YamlSourceDecoder.parser((Map)value);
                    rootMap.put(key, new YamlNode(key, childNodes));
                    continue;
                }
                if (value instanceof List) {
                    for (Object item : (List)value) {
                        if (item instanceof Map) {
                            Map<String, YamlNode> childNodes = YamlSourceDecoder.parser((Map)item);
                            childList.add(new YamlNode(key, childNodes));
                            continue;
                        }
                        childList.add(new YamlNode(key, item));
                    }
                    rootMap.put(key, new YamlNode(key, value));
                    continue;
                }
                rootMap.put(key, new YamlNode(key, value));
            }
            YamlNode root = new YamlNode("$root", rootMap.isEmpty() ? null : rootMap);
            YamlNode childRoot = new YamlNode("$child", this.rowsNodePath.isEmpty() ? null : childList);
            return new YamlSourceData(root, childRoot);
        }
        catch (Exception e) {
            log.error("Data parsing failed", (Throwable)e);
            return null;
        }
    }

    private static Map<String, YamlNode> parser(Map<String, Object> yamlData) {
        HashMap<String, YamlNode> yamlNodes = new HashMap<String, YamlNode>();
        for (Map.Entry<String, Object> entry : yamlData.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                yamlNodes.put(key, new YamlNode(key, YamlSourceDecoder.parser((Map)value)));
                continue;
            }
            if (value instanceof List) {
                ArrayList<YamlNode> list = new ArrayList<YamlNode>();
                for (Object item : (List)value) {
                    if (item instanceof Map) {
                        list.add(new YamlNode(key, YamlSourceDecoder.parser((Map)item)));
                        continue;
                    }
                    list.add(new YamlNode(key, item));
                }
                yamlNodes.put(key, new YamlNode(key, list));
                continue;
            }
            yamlNodes.put(key, new YamlNode(key, value));
        }
        return yamlNodes;
    }
}

