/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.sender.http;

import java.util.Objects;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.ReportProtocol;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.network.http.HttpContentType;

public class HttpMsgSenderConfig
extends ProxyClientConfig
implements Cloneable {
    private boolean rptDataByHttps = false;
    private HttpContentType httpContentType = HttpContentType.APPLICATION_X_WWW_FORM_URLENCODED;
    private String httpEventsSeparator = "\n";
    private boolean sepEventByLF = true;
    private int httpConTimeoutMs = 8000;
    private int httpSocketTimeoutMs = 10000;
    private boolean discardHttpCacheWhenClosing = false;
    private long httpCloseWaitPeriodMs = 20000L;
    private long httpNodeReuseWaitIfFailMs = 20000L;
    private int httpAsyncRptWorkerNum = SdkConsts.VAL_DEF_HTTP_ASYNC_RPT_WORKER_NUM;
    private int httpAsyncWorkerIdleWaitMs = 300;

    public HttpMsgSenderConfig(boolean visitMgrByHttps, String managerIP, int managerPort, String groupId) throws ProxySdkException {
        super(visitMgrByHttps, managerIP, managerPort, groupId, ReportProtocol.HTTP, null);
        this.setMaxInFlightReqCnt(2000);
    }

    public HttpMsgSenderConfig(String managerAddress, String groupId) throws ProxySdkException {
        super(managerAddress, groupId, ReportProtocol.HTTP, null);
        this.setMaxInFlightReqCnt(2000);
    }

    public HttpMsgSenderConfig(boolean visitMgrByHttps, String managerIP, int managerPort, String groupId, String mgrAuthSecretId, String mgrAuthSecretKey) throws ProxySdkException {
        super(visitMgrByHttps, managerIP, managerPort, groupId, ReportProtocol.HTTP, null);
        this.setMaxInFlightReqCnt(2000);
        this.setMgrAuthzInfo(true, mgrAuthSecretId, mgrAuthSecretKey);
    }

    public HttpMsgSenderConfig(String managerAddress, String groupId, String mgrAuthSecretId, String mgrAuthSecretKey) throws ProxySdkException {
        super(managerAddress, groupId, ReportProtocol.HTTP, null);
        this.setMaxInFlightReqCnt(2000);
        this.setMgrAuthzInfo(true, mgrAuthSecretId, mgrAuthSecretKey);
    }

    public boolean isRptDataByHttps() {
        return this.rptDataByHttps;
    }

    public void setRptDataByHttps(boolean rptDataByHttps) {
        this.rptDataByHttps = rptDataByHttps;
    }

    public HttpContentType getContentType() {
        return this.httpContentType;
    }

    public void setContentType(HttpContentType httpContentType) {
        if (httpContentType == null) {
            return;
        }
        this.httpContentType = httpContentType;
    }

    public String getHttpEventsSeparator() {
        return this.httpEventsSeparator;
    }

    public boolean isSepEventByLF() {
        return this.sepEventByLF;
    }

    public void setHttpEventsSeparator(String httpEventsSeparator) {
        if (StringUtils.isBlank(httpEventsSeparator)) {
            throw new IllegalArgumentException("eventSeparator cannot be blank");
        }
        String tmpValue = httpEventsSeparator.trim();
        if (tmpValue.length() != 1) {
            throw new IllegalArgumentException("eventSeparator must be a single character");
        }
        this.httpEventsSeparator = tmpValue;
        this.sepEventByLF = this.httpEventsSeparator.equals("\n");
    }

    public int getHttpConTimeoutMs() {
        return this.httpConTimeoutMs;
    }

    public void setHttpConTimeoutMs(int httpConTimeoutMs) {
        this.httpConTimeoutMs = Math.max(2000, httpConTimeoutMs);
    }

    public int getHttpSocketTimeoutMs() {
        return this.httpSocketTimeoutMs;
    }

    public void setHttpSocketTimeoutMs(int httpSocketTimeoutMs) {
        this.httpSocketTimeoutMs = Math.min(60000, Math.max(2000, httpSocketTimeoutMs));
    }

    public boolean isDiscardHttpCacheWhenClosing() {
        return this.discardHttpCacheWhenClosing;
    }

    public void setDiscardHttpCacheWhenClosing(boolean discardHttpCacheWhenClosing) {
        this.discardHttpCacheWhenClosing = discardHttpCacheWhenClosing;
    }

    public long getHttpCloseWaitPeriodMs() {
        return this.httpCloseWaitPeriodMs;
    }

    public void setHttpCloseWaitPeriodMs(long httpCloseWaitPeriodMs) {
        this.httpCloseWaitPeriodMs = httpCloseWaitPeriodMs;
        this.httpCloseWaitPeriodMs = Math.min(90000L, Math.max(100L, httpCloseWaitPeriodMs));
    }

    public long getHttpNodeReuseWaitIfFailMs() {
        return this.httpNodeReuseWaitIfFailMs;
    }

    public void setHttpNodeReuseWaitIfFailMs(long httpNodeReuseWaitIfFailMs) {
        this.httpNodeReuseWaitIfFailMs = Math.min(300000L, Math.max(1000L, httpNodeReuseWaitIfFailMs));
    }

    public int getHttpAsyncRptWorkerNum() {
        return this.httpAsyncRptWorkerNum;
    }

    public void setHttpAsyncRptWorkerNum(int httpAsyncRptWorkerNum) {
        this.httpAsyncRptWorkerNum = Math.max(1, httpAsyncRptWorkerNum);
    }

    public int getHttpAsyncWorkerIdleWaitMs() {
        return this.httpAsyncWorkerIdleWaitMs;
    }

    public void setHttpAsyncWorkerIdleWaitMs(int httpAsyncWorkerIdleWaitMs) {
        this.httpAsyncWorkerIdleWaitMs = Math.min(3000, Math.max(10, httpAsyncWorkerIdleWaitMs));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMsgSenderConfig that = (HttpMsgSenderConfig)o;
        return this.rptDataByHttps == that.rptDataByHttps && this.sepEventByLF == that.sepEventByLF && this.httpConTimeoutMs == that.httpConTimeoutMs && this.httpSocketTimeoutMs == that.httpSocketTimeoutMs && this.discardHttpCacheWhenClosing == that.discardHttpCacheWhenClosing && this.httpCloseWaitPeriodMs == that.httpCloseWaitPeriodMs && this.httpNodeReuseWaitIfFailMs == that.httpNodeReuseWaitIfFailMs && this.httpAsyncRptWorkerNum == that.httpAsyncRptWorkerNum && this.httpAsyncWorkerIdleWaitMs == that.httpAsyncWorkerIdleWaitMs && this.httpContentType == that.httpContentType && Objects.equals(this.httpEventsSeparator, that.httpEventsSeparator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.rptDataByHttps, this.httpContentType, this.httpEventsSeparator, this.sepEventByLF, this.httpConTimeoutMs, this.httpSocketTimeoutMs, this.discardHttpCacheWhenClosing, this.httpCloseWaitPeriodMs, this.httpNodeReuseWaitIfFailMs, this.httpAsyncRptWorkerNum, this.httpAsyncWorkerIdleWaitMs});
    }

    @Override
    public HttpMsgSenderConfig clone() {
        try {
            HttpMsgSenderConfig copy = (HttpMsgSenderConfig)super.clone();
            if (copy != null) {
                copy.httpContentType = this.httpContentType;
            }
            return copy;
        }
        catch (Throwable ex) {
            logger.warn("Failed to clone HttpMsgSenderConfig", ex);
            return null;
        }
    }

    public String toString() {
        StringBuilder strBuff = new StringBuilder("HttpMsgSenderConfig{rptDataByHttps=").append(this.rptDataByHttps).append(", httpContentType=").append((Object)this.httpContentType).append(", httpEventsSeparator='").append(this.httpEventsSeparator).append("', sepEventByLF=").append(this.sepEventByLF).append(", httpConTimeoutMs=").append(this.httpConTimeoutMs).append(", httpSocketTimeoutMs=").append(this.httpSocketTimeoutMs).append(", discardHttpCacheWhenClosing=").append(this.discardHttpCacheWhenClosing).append(", httpCloseWaitPeriodMs=").append(this.httpCloseWaitPeriodMs).append(", httpNodeReuseWaitIfFailMs=").append(this.httpNodeReuseWaitIfFailMs).append(", httpAsyncRptWorkerNum=").append(this.httpAsyncRptWorkerNum).append(", httpAsyncWorkerIdleWaitMs=").append(this.httpAsyncWorkerIdleWaitMs);
        return super.getSetting(strBuff);
    }
}

