/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.Configurables;
import org.apache.flume.instrumentation.SourceCounter;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.SyslogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogUDPSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    public static final int DEFAULT_MIN_SIZE = 2048;
    public static final int DEFAULT_INITIAL_SIZE = 2048;
    private static final Logger logger = LoggerFactory.getLogger(SyslogUDPSource.class);
    private final int maxsize = 65536;
    private int port;
    private String host = null;
    private Map<String, String> formaterProp;
    private Set<String> keepFields;
    private String clientIPHeader;
    private String clientHostnameHeader;
    private EventLoopGroup group;
    private Channel channel;
    private SourceCounter sourceCounter;

    @Override
    public void start() {
        this.group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new SyslogUdpHandler(this.formaterProp, this.keepFields, this.clientIPHeader, this.clientHostnameHeader));
            this.channel = this.host == null ? b.bind(this.port).sync().channel() : b.bind(this.host, this.port).sync().channel();
        }
        catch (InterruptedException ex) {
            logger.warn("netty server startup was interrupted", (Throwable)ex);
        }
        this.sourceCounter.start();
        super.start();
    }

    @Override
    public void stop() {
        logger.info("Syslog UDP Source stopping...");
        logger.info("Metrics: {}", (Object)this.sourceCounter);
        this.group.shutdownGracefully();
        this.sourceCounter.stop();
        super.stop();
    }

    @Override
    public void configure(Context context) {
        Configurables.ensureRequiredNonNull(context, "port");
        this.port = context.getInteger("port");
        this.host = context.getString("host");
        this.formaterProp = context.getSubProperties("format.");
        this.keepFields = SyslogUtils.chooseFieldsToKeep(context.getString("keepFields", "none"));
        this.clientIPHeader = context.getString("clientIPHeader");
        this.clientHostnameHeader = context.getString("clientHostnameHeader");
        if (this.sourceCounter == null) {
            this.sourceCounter = new SourceCounter(this.getName());
        }
    }

    @VisibleForTesting
    InetSocketAddress getBoundAddress() {
        SocketAddress localAddress = this.channel.localAddress();
        if (!(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Not bound to an internet address");
        }
        return (InetSocketAddress)localAddress;
    }

    @VisibleForTesting
    SourceCounter getSourceCounter() {
        return this.sourceCounter;
    }

    public class SyslogUdpHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        SyslogUtils syslogUtils = new SyslogUtils(2048, null, true);
        private final String clientIPHeader;
        private final String clientHostnameHeader;

        SyslogUdpHandler(Map<String, String> formatProps, Set<String> keepFields, String clientIPHeader, String clientHostnameHeader) {
            this.syslogUtils.addFormats(formatProps);
            this.syslogUtils.setKeepFields(keepFields);
            this.clientIPHeader = clientIPHeader;
            this.clientHostnameHeader = clientHostnameHeader;
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
            try {
                this.syslogUtils.setEventSize(65536);
                Event e = this.syslogUtils.extractEvent((ByteBuf)packet.content());
                if (e == null) {
                    return;
                }
                if (this.clientIPHeader != null) {
                    e.getHeaders().put(this.clientIPHeader, SyslogUtils.getIP(packet.sender()));
                }
                if (this.clientHostnameHeader != null) {
                    e.getHeaders().put(this.clientHostnameHeader, SyslogUtils.getHostname(packet.sender()));
                }
                SyslogUDPSource.this.sourceCounter.incrementEventReceivedCount();
                SyslogUDPSource.this.getChannelProcessor().processEvent(e);
                SyslogUDPSource.this.sourceCounter.incrementEventAcceptedCount();
            }
            catch (ChannelException ex) {
                logger.error("Error writting to channel", (Throwable)ex);
                SyslogUDPSource.this.sourceCounter.incrementChannelWriteFail();
            }
            catch (RuntimeException ex) {
                logger.error("Error parsing event from syslog stream, event dropped", (Throwable)ex);
                SyslogUDPSource.this.sourceCounter.incrementEventReadFail();
            }
        }
    }
}

