/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttTask.class);
    private String topic;
    private int instanceLimit = 1;
    private AtomicBoolean isAdded = new AtomicBoolean(false);
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");

    public boolean isProfileValid(TaskProfile profile) {
        if (!profile.allRequiredKeyExist()) {
            LOGGER.info("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.mqttTask.topic")) {
            LOGGER.info("task profile needs topic");
            return false;
        }
        if (!profile.hasKey("task.mqttTask.serverURI")) {
            LOGGER.info("task profile needs serverUri");
            return false;
        }
        if (!profile.hasKey("task.mqttTask.userName")) {
            LOGGER.info("task profile needs username");
            return false;
        }
        if (!profile.hasKey("task.mqttTask.password")) {
            LOGGER.info("task profile needs password");
            return false;
        }
        return true;
    }

    protected void setInstanceLimit(int instanceLimit) {
        this.instanceLimit = instanceLimit;
    }

    @Override
    protected int getInstanceLimit() {
        return this.instanceLimit;
    }

    @Override
    protected void initTask() {
        LOGGER.info("Mqtt commonInit: {}", (Object)this.taskProfile.toJsonStr());
        this.topic = this.taskProfile.get("task.mqttTask.topic");
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        if (this.isAdded.get()) {
            return list;
        }
        String dataTime = LocalDateTime.now().format(this.dateTimeFormatter);
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(this.topic, "H", dataTime, AgentUtils.getCurrentTime());
        LOGGER.info("taskProfile.createInstanceProfile(mqtt): {}", (Object)instanceProfile.toJsonStr());
        list.add(instanceProfile);
        this.isAdded.set(true);
        return list;
    }
}

