/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible
public final class Functions {
    private Functions() {
    }

    public static Function<Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <K, V> Function<K, V> forMap(Map<K, V> map2) {
        return new FunctionForMapNoDefault<K, V>(map2);
    }

    public static <K, V> Function<K, V> forMap(Map<K, ? extends V> map2, @Nullable V defaultValue) {
        return new ForMapWithDefault<K, V>(map2, defaultValue);
    }

    public static <A, B, C> Function<A, C> compose(Function<B, C> g, Function<A, ? extends B> f2) {
        return new FunctionComposition<A, B, C>(g, f2);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        return new PredicateFunction(predicate);
    }

    public static <E> Function<Object, E> constant(@Nullable E value2) {
        return new ConstantFunction<E>(value2);
    }

    @Beta
    public static <T> Function<Object, T> forSupplier(Supplier<T> supplier) {
        return new SupplierFunction(supplier);
    }

    private static class SupplierFunction<T>
    implements Function<Object, T>,
    Serializable {
        private final Supplier<T> supplier;
        private static final long serialVersionUID = 0L;

        private SupplierFunction(Supplier<T> supplier) {
            this.supplier = Preconditions.checkNotNull(supplier);
        }

        @Override
        public T apply(@Nullable Object input) {
            return this.supplier.get();
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 instanceof SupplierFunction) {
                SupplierFunction that2 = (SupplierFunction)obj2;
                return this.supplier.equals(that2.supplier);
            }
            return false;
        }

        public int hashCode() {
            return this.supplier.hashCode();
        }

        public String toString() {
            return "forSupplier(" + this.supplier + ")";
        }
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        private final E value;
        private static final long serialVersionUID = 0L;

        public ConstantFunction(@Nullable E value2) {
            this.value = value2;
        }

        @Override
        public E apply(@Nullable Object from2) {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 instanceof ConstantFunction) {
                ConstantFunction that2 = (ConstantFunction)obj2;
                return Objects.equal(this.value, that2.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static class PredicateFunction<T>
    implements Function<T, Boolean>,
    Serializable {
        private final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        private PredicateFunction(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public Boolean apply(@Nullable T t) {
            return this.predicate.apply(t);
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 instanceof PredicateFunction) {
                PredicateFunction that2 = (PredicateFunction)obj2;
                return this.predicate.equals(that2.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }

        public String toString() {
            return "forPredicate(" + this.predicate + ")";
        }
    }

    private static class FunctionComposition<A, B, C>
    implements Function<A, C>,
    Serializable {
        private final Function<B, C> g;
        private final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        public FunctionComposition(Function<B, C> g, Function<A, ? extends B> f2) {
            this.g = Preconditions.checkNotNull(g);
            this.f = Preconditions.checkNotNull(f2);
        }

        @Override
        public C apply(@Nullable A a2) {
            return this.g.apply(this.f.apply(a2));
        }

        @Override
        public boolean equals(@Nullable Object obj2) {
            if (obj2 instanceof FunctionComposition) {
                FunctionComposition that2 = (FunctionComposition)obj2;
                return this.f.equals(that2.f) && this.g.equals(that2.g);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.g.hashCode();
        }

        public String toString() {
            return this.g.toString() + "(" + this.f.toString() + ")";
        }
    }

    private static class ForMapWithDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, ? extends V> map;
        final V defaultValue;
        private static final long serialVersionUID = 0L;

        ForMapWithDefault(Map<K, ? extends V> map2, @Nullable V defaultValue) {
            this.map = Preconditions.checkNotNull(map2);
            this.defaultValue = defaultValue;
        }

        @Override
        public V apply(@Nullable K key) {
            V result2 = this.map.get(key);
            return result2 != null || this.map.containsKey(key) ? result2 : this.defaultValue;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o instanceof ForMapWithDefault) {
                ForMapWithDefault that2 = (ForMapWithDefault)o;
                return this.map.equals(that2.map) && Objects.equal(this.defaultValue, that2.defaultValue);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.map, this.defaultValue);
        }

        public String toString() {
            return "forMap(" + this.map + ", defaultValue=" + this.defaultValue + ")";
        }
    }

    private static class FunctionForMapNoDefault<K, V>
    implements Function<K, V>,
    Serializable {
        final Map<K, V> map;
        private static final long serialVersionUID = 0L;

        FunctionForMapNoDefault(Map<K, V> map2) {
            this.map = Preconditions.checkNotNull(map2);
        }

        @Override
        public V apply(@Nullable K key) {
            V result2 = this.map.get(key);
            Preconditions.checkArgument(result2 != null || this.map.containsKey(key), "Key '%s' not present in map", key);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o instanceof FunctionForMapNoDefault) {
                FunctionForMapNoDefault that2 = (FunctionForMapNoDefault)o;
                return this.map.equals(that2.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return "forMap(" + this.map + ")";
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object apply(@Nullable Object o) {
            return o;
        }

        public String toString() {
            return "identity";
        }
    }

    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object o) {
            Preconditions.checkNotNull(o);
            return o.toString();
        }

        public String toString() {
            return "toString";
        }
    }
}

