/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.tags;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import io.opentracing.tag.StringTag;

public class SpanTags {
    public static final StringTag CURR_APP_TAG = new StringTag("curr.app");

    public static void putTags(String key, String val) {
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (SpanTags.checkTags(currentSpan)) {
            currentSpan.setTag(key, val);
        }
    }

    public static void putTags(String key, Number val) {
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (SpanTags.checkTags(currentSpan)) {
            currentSpan.setTag(key, val);
        }
    }

    public static void putTags(String key, Boolean val) {
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        if (SpanTags.checkTags(currentSpan)) {
            currentSpan.setTag(key, val);
        }
    }

    private static boolean checkTags(SofaTracerSpan currentSpan) {
        if (currentSpan == null) {
            SelfLog.error("Current stage has no span exist in SofaTracerContext.");
            return false;
        }
        String componentType = currentSpan.getSofaTracer().getTracerType();
        if (!componentType.equalsIgnoreCase("flexible-biz")) {
            SelfLog.error("Cannot set tag to component. current component is [" + componentType + "]");
            return false;
        }
        return true;
    }
}

